
package com.google.api.gax.core;

import javax.annotation.Generated;
import org.joda.time.Duration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_BackoffParams extends BackoffParams {

  private final Duration initialDelay;
  private final double delayMultiplier;
  private final Duration maxDelay;

  private AutoValue_BackoffParams(
      Duration initialDelay,
      double delayMultiplier,
      Duration maxDelay) {
    if (initialDelay == null) {
      throw new NullPointerException("Null initialDelay");
    }
    this.initialDelay = initialDelay;
    this.delayMultiplier = delayMultiplier;
    if (maxDelay == null) {
      throw new NullPointerException("Null maxDelay");
    }
    this.maxDelay = maxDelay;
  }

  @Override
  public Duration getInitialDelay() {
    return initialDelay;
  }

  @Override
  public double getDelayMultiplier() {
    return delayMultiplier;
  }

  @Override
  public Duration getMaxDelay() {
    return maxDelay;
  }

  @Override
  public String toString() {
    return "BackoffParams{"
        + "initialDelay=" + initialDelay + ", "
        + "delayMultiplier=" + delayMultiplier + ", "
        + "maxDelay=" + maxDelay
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof BackoffParams) {
      BackoffParams that = (BackoffParams) o;
      return (this.initialDelay.equals(that.getInitialDelay()))
           && (Double.doubleToLongBits(this.delayMultiplier) == Double.doubleToLongBits(that.getDelayMultiplier()))
           && (this.maxDelay.equals(that.getMaxDelay()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= initialDelay.hashCode();
    h *= 1000003;
    h ^= (Double.doubleToLongBits(delayMultiplier) >>> 32) ^ Double.doubleToLongBits(delayMultiplier);
    h *= 1000003;
    h ^= maxDelay.hashCode();
    return h;
  }

  static final class Builder extends BackoffParams.Builder {
    private Duration initialDelay;
    private Double delayMultiplier;
    private Duration maxDelay;
    Builder() {
    }
    Builder(BackoffParams source) {
      this.initialDelay = source.getInitialDelay();
      this.delayMultiplier = source.getDelayMultiplier();
      this.maxDelay = source.getMaxDelay();
    }
    @Override
    public BackoffParams.Builder setInitialDelay(Duration initialDelay) {
      this.initialDelay = initialDelay;
      return this;
    }
    @Override
    public BackoffParams.Builder setDelayMultiplier(double delayMultiplier) {
      this.delayMultiplier = delayMultiplier;
      return this;
    }
    @Override
    public BackoffParams.Builder setMaxDelay(Duration maxDelay) {
      this.maxDelay = maxDelay;
      return this;
    }
    @Override
    public BackoffParams autoBuild() {
      String missing = "";
      if (initialDelay == null) {
        missing += " initialDelay";
      }
      if (delayMultiplier == null) {
        missing += " delayMultiplier";
      }
      if (maxDelay == null) {
        missing += " maxDelay";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_BackoffParams(
          this.initialDelay,
          this.delayMultiplier,
          this.maxDelay);
    }
  }
}
