/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.gax.core.FlowControlSettings;
import com.google.common.base.Preconditions;
import java.util.concurrent.Semaphore;
import javax.annotation.Nullable;

public class FlowController {
    @Nullable
    private final Semaphore outstandingElementCount;
    @Nullable
    private final Semaphore outstandingByteCount;
    private final boolean failOnLimits;
    @Nullable
    private final Integer maxOutstandingElementCount;
    @Nullable
    private final Integer maxOutstandingRequestBytes;

    public FlowController(FlowControlSettings settings) {
        switch (settings.getLimitExceededBehavior()) {
            case ThrowException: {
                this.failOnLimits = true;
                break;
            }
            case Block: {
                this.failOnLimits = false;
                break;
            }
            case Ignore: {
                this.failOnLimits = false;
                this.maxOutstandingElementCount = null;
                this.maxOutstandingRequestBytes = null;
                this.outstandingElementCount = null;
                this.outstandingByteCount = null;
                return;
            }
            default: {
                throw new IllegalArgumentException("Unknown LimitBehaviour: " + (Object)((Object)settings.getLimitExceededBehavior()));
            }
        }
        this.maxOutstandingElementCount = settings.getMaxOutstandingElementCount();
        this.maxOutstandingRequestBytes = settings.getMaxOutstandingRequestBytes();
        this.outstandingElementCount = this.maxOutstandingElementCount != null ? new Semaphore(this.maxOutstandingElementCount) : null;
        this.outstandingByteCount = this.maxOutstandingRequestBytes != null ? new Semaphore(this.maxOutstandingRequestBytes) : null;
    }

    public void reserve(int elements, int bytes) throws FlowControlException {
        Preconditions.checkArgument((elements > 0 ? 1 : 0) != 0);
        if (this.outstandingElementCount != null) {
            if (!this.failOnLimits) {
                this.outstandingElementCount.acquireUninterruptibly(elements);
            } else if (!this.outstandingElementCount.tryAcquire(elements)) {
                throw new MaxOutstandingElementCountReachedException(this.maxOutstandingElementCount);
            }
        }
        if (this.outstandingByteCount != null) {
            int permitsToDraw = Math.min(bytes, this.maxOutstandingRequestBytes);
            if (!this.failOnLimits) {
                this.outstandingByteCount.acquireUninterruptibly(permitsToDraw);
            } else if (!this.outstandingByteCount.tryAcquire(permitsToDraw)) {
                throw new MaxOutstandingRequestBytesReachedException(this.maxOutstandingRequestBytes);
            }
        }
    }

    public void release(int elements, int bytes) {
        Preconditions.checkArgument((elements > 0 ? 1 : 0) != 0);
        if (this.outstandingElementCount != null) {
            this.outstandingElementCount.release(elements);
        }
        if (this.outstandingByteCount != null) {
            int permitsToReturn = Math.min(bytes, this.maxOutstandingRequestBytes);
            this.outstandingByteCount.release(permitsToReturn);
        }
    }

    public static enum LimitExceededBehavior {
        ThrowException,
        Block,
        Ignore;

    }

    public static final class MaxOutstandingRequestBytesReachedException
    extends FlowControlException {
        private final int currentMaxBytes;

        public MaxOutstandingRequestBytesReachedException(int currentMaxBytes) {
            this.currentMaxBytes = currentMaxBytes;
        }

        public int getCurrentMaxBundleBytes() {
            return this.currentMaxBytes;
        }

        @Override
        public String toString() {
            return String.format("The maximum number of bundle bytes: %d have been reached.", this.currentMaxBytes);
        }
    }

    public static final class MaxOutstandingElementCountReachedException
    extends FlowControlException {
        private final int currentMaxElementCount;

        public MaxOutstandingElementCountReachedException(int currentMaxElementCount) {
            this.currentMaxElementCount = currentMaxElementCount;
        }

        public int getCurrentMaxBundleElementCount() {
            return this.currentMaxElementCount;
        }

        @Override
        public String toString() {
            return String.format("The maximum number of bundle elements: %d have been reached.", this.currentMaxElementCount);
        }
    }

    public static class FlowControlRuntimeException
    extends RuntimeException {
        private FlowControlRuntimeException(FlowControlException e) {
            super(e);
        }

        public static FlowControlRuntimeException fromFlowControlException(FlowControlException e) {
            return new FlowControlRuntimeException(e);
        }
    }

    public static abstract class FlowControlException
    extends Exception {
        private FlowControlException() {
        }
    }
}

