/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.bundling;

import com.google.api.gax.bundling.AutoValue_BundlingSettings;
import com.google.api.gax.core.FlowControlSettings;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public abstract class BundlingSettings {
    @Nullable
    public abstract Long getElementCountThreshold();

    @Nullable
    public abstract Long getRequestByteThreshold();

    @Nullable
    public abstract Duration getDelayThreshold();

    public abstract Boolean getIsEnabled();

    public abstract FlowControlSettings getFlowControlSettings();

    public static Builder newBuilder() {
        return new AutoValue_BundlingSettings.Builder().setIsEnabled(true).setFlowControlSettings(FlowControlSettings.getDefaultInstance());
    }

    public Builder toBuilder() {
        return new AutoValue_BundlingSettings.Builder(this);
    }

    public static abstract class Builder {
        public abstract Builder setElementCountThreshold(Long var1);

        @Deprecated
        public Builder setElementCountThreshold(Integer elementCountThreshold) {
            return this.setElementCountThreshold(elementCountThreshold.longValue());
        }

        public abstract Builder setRequestByteThreshold(Long var1);

        @Deprecated
        public Builder setRequestByteThreshold(Integer requestByteThreshold) {
            return this.setRequestByteThreshold(requestByteThreshold.longValue());
        }

        public abstract Builder setDelayThreshold(Duration var1);

        public abstract Builder setIsEnabled(Boolean var1);

        public abstract Builder setFlowControlSettings(FlowControlSettings var1);

        abstract BundlingSettings autoBuild();

        public BundlingSettings build() {
            BundlingSettings settings = this.autoBuild();
            Preconditions.checkArgument((settings.getElementCountThreshold() == null || settings.getElementCountThreshold() > 0L ? 1 : 0) != 0, (Object)"elementCountThreshold must be either unset or positive");
            Preconditions.checkArgument((settings.getRequestByteThreshold() == null || settings.getRequestByteThreshold() > 0L ? 1 : 0) != 0, (Object)"requestByteThreshold must be either unset or positive");
            Preconditions.checkArgument((settings.getDelayThreshold() == null || settings.getDelayThreshold().compareTo((ReadableDuration)Duration.ZERO) > 0 ? 1 : 0) != 0, (Object)"delayThreshold must be either unset or positive");
            return settings;
        }
    }
}

