/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.gax.core.AbstractApiFuture;
import com.google.api.gax.core.ApiFuture;
import com.google.api.gax.core.ApiFutureCallback;
import com.google.api.gax.core.Function;
import com.google.api.gax.core.internal.ApiFutureToListenableFuture;
import com.google.api.gax.core.internal.ListenableFutureToApiFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import javax.annotation.Nullable;

public final class ApiFutures {
    private ApiFutures() {
    }

    public static <V> void addCallback(ApiFuture<V> future, final ApiFutureCallback<? super V> callback) {
        Futures.addCallback(ApiFutures.listenableFutureForApiFuture(future), (FutureCallback)new FutureCallback<V>(){

            public void onFailure(Throwable t) {
                callback.onFailure(t);
            }

            public void onSuccess(V v) {
                callback.onSuccess(v);
            }
        });
    }

    public static <V, X extends Throwable> ApiFuture catching(ApiFuture<? extends V> input, Class<X> exceptionType, Function<? super X, ? extends V> callback) {
        ListenableFuture catchingFuture = Futures.catching(ApiFutures.listenableFutureForApiFuture(input), exceptionType, new GaxFunctionToGuavaFunction<X, V>(callback));
        return new ListenableFutureToApiFuture(catchingFuture);
    }

    public static <V> ApiFuture<V> immediateFuture(V value) {
        return new ListenableFutureToApiFuture(Futures.immediateFuture(value));
    }

    public static <V> ApiFuture<V> immediateFailedFuture(Throwable throwable) {
        return new ListenableFutureToApiFuture(Futures.immediateFailedFuture((Throwable)throwable));
    }

    public static <V, X> ApiFuture<X> transform(ApiFuture<? extends V> input, Function<? super V, ? extends X> function) {
        return new ListenableFutureToApiFuture(Futures.transform(ApiFutures.listenableFutureForApiFuture(input), new GaxFunctionToGuavaFunction<V, X>(function)));
    }

    private static <V> ListenableFuture<V> listenableFutureForApiFuture(ApiFuture<V> apiFuture) {
        Object listenableFuture = apiFuture instanceof AbstractApiFuture ? ((AbstractApiFuture)apiFuture).getInternalListenableFuture() : new ApiFutureToListenableFuture<V>(apiFuture);
        return listenableFuture;
    }

    private static class GaxFunctionToGuavaFunction<X, V>
    implements com.google.common.base.Function<X, V> {
        private Function<? super X, ? extends V> f;

        public GaxFunctionToGuavaFunction(Function<? super X, ? extends V> f) {
            this.f = f;
        }

        @Nullable
        public V apply(@Nullable X input) {
            return this.f.apply(input);
        }
    }
}

