/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.core.Page;
import com.google.api.gax.grpc.ApiException;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.PagedListDescriptor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.grpc.StatusRuntimeException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Future;

class PageImpl<RequestT, ResponseT, ResourceT>
implements Page<RequestT, ResponseT, ResourceT> {
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final PagedListDescriptor<RequestT, ResponseT, ResourceT> pageDescriptor;
    private final RequestT request;
    private final CallContext context;
    private ResponseT response;

    public PageImpl(UnaryCallable<RequestT, ResponseT> callable, PagedListDescriptor<RequestT, ResponseT, ResourceT> pageDescriptor, RequestT request, CallContext context) {
        this.callable = callable;
        this.pageDescriptor = pageDescriptor;
        this.request = request;
        this.context = context;
        this.response = PageImpl.getUnchecked(callable.futureCall(request, context));
    }

    @Override
    public Iterator<ResourceT> iterator() {
        return this.pageDescriptor.extractResources(this.response).iterator();
    }

    @Override
    public boolean hasNextPage() {
        return !this.getNextPageToken().equals(this.pageDescriptor.emptyToken());
    }

    @Override
    public Object getNextPageToken() {
        return this.pageDescriptor.extractNextToken(this.response);
    }

    @Override
    public Page<RequestT, ResponseT, ResourceT> getNextPage() {
        if (!this.hasNextPage()) {
            throw new NoSuchElementException("Could not complete getNextPage operation: there are no more pages to retrieve.");
        }
        RequestT nextRequest = this.pageDescriptor.injectToken(this.request, this.getNextPageToken());
        return new PageImpl<RequestT, ResponseT, ResourceT>(this.callable, this.pageDescriptor, nextRequest, this.context);
    }

    @Override
    public Page<RequestT, ResponseT, ResourceT> getNextPage(int pageSize) {
        if (!this.hasNextPage()) {
            throw new NoSuchElementException("Could not complete getNextPage operation: there are no more pages to retrieve.");
        }
        RequestT nextRequest = this.pageDescriptor.injectToken(this.request, this.getNextPageToken());
        nextRequest = this.pageDescriptor.injectPageSize(nextRequest, pageSize);
        return new PageImpl<RequestT, ResponseT, ResourceT>(this.callable, this.pageDescriptor, nextRequest, this.context);
    }

    @Override
    public int getPageElementCount() {
        return Iterators.size(this.iterator());
    }

    @Override
    public Iterable<Page<RequestT, ResponseT, ResourceT>> iteratePages() {
        return new Iterable<Page<RequestT, ResponseT, ResourceT>>(){

            @Override
            public Iterator<Page<RequestT, ResponseT, ResourceT>> iterator() {
                return new PageIterator(PageImpl.this);
            }
        };
    }

    @Override
    public RequestT getRequestObject() {
        return this.request;
    }

    @Override
    public ResponseT getResponseObject() {
        return this.response;
    }

    static <ResponseT> ResponseT getUnchecked(Future<ResponseT> listenableFuture) {
        try {
            return (ResponseT)Futures.getUnchecked(listenableFuture);
        }
        catch (UncheckedExecutionException exception) {
            Throwables.propagateIfInstanceOf((Throwable)exception.getCause(), ApiException.class);
            if (exception.getCause() instanceof StatusRuntimeException) {
                StatusRuntimeException statusException = (StatusRuntimeException)exception.getCause();
                throw new ApiException((Throwable)statusException, statusException.getStatus().getCode(), false);
            }
            throw exception;
        }
    }

    private static class PageIterator<RequestT, ResponseT, ResourceT>
    extends AbstractIterator<Page<RequestT, ResponseT, ResourceT>> {
        private Page<RequestT, ResponseT, ResourceT> currentPage;
        boolean firstPageFlag;

        private PageIterator(Page<RequestT, ResponseT, ResourceT> firstPage) {
            this.currentPage = firstPage;
            this.firstPageFlag = true;
        }

        protected Page<RequestT, ResponseT, ResourceT> computeNext() {
            if (this.firstPageFlag) {
                this.firstPageFlag = false;
            } else {
                Page<RequestT, ResponseT, ResourceT> page = this.currentPage = this.currentPage.hasNextPage() ? this.currentPage.getNextPage() : null;
            }
            if (this.currentPage == null) {
                return (Page)this.endOfData();
            }
            return this.currentPage;
        }
    }
}

