/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import java.util.Properties;

public class PropertiesProvider {
    private static final Properties gaxProperties = new Properties();
    private static final String DEFAULT_VERSION = "";

    public static String getGaxVersion() {
        String gaxVersion = PropertiesProvider.loadGaxProperty("version");
        return gaxVersion != null ? gaxVersion : DEFAULT_VERSION;
    }

    public static String getGrpcVersion() {
        String grpcVersion = PropertiesProvider.loadGaxProperty("grpc_version");
        return grpcVersion != null ? grpcVersion : DEFAULT_VERSION;
    }

    public static String loadProperty(Class<?> loadedClass, String propertyFilePath, String key) {
        try {
            Properties properties = new Properties();
            properties.load(loadedClass.getResourceAsStream(propertyFilePath));
            return properties.getProperty(key);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    private static String loadGaxProperty(String key) {
        try {
            if (gaxProperties.isEmpty()) {
                gaxProperties.load(PropertiesProvider.class.getResourceAsStream("/com/google/api/gax/gax.properties"));
            }
            return gaxProperties.getProperty(key);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }
}

