/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.client.util.Lists;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@BetaApi
public class ApiClientHeaderProvider
implements HeaderProvider {
    private static final String DEFAULT_VERSION = "";
    private final String apiClientHeaderLineKey;
    private final String clientLibName;
    private final String clientLibVersion;
    private final String generatorName;
    private final String generatorVersion;
    private final List<String> apiClientHeaderLineData;
    private final String googleCloudResourcePrefix;
    private final Map<String, String> headers;

    private ApiClientHeaderProvider(String apiClientHeaderLineKey, String clientLibName, String clientLibVersion, String generatorName, String generatorVersion, List<String> apiClientHeaderLineData, String googleCloudResourcePrefix) {
        this.apiClientHeaderLineKey = apiClientHeaderLineKey;
        this.clientLibName = clientLibName;
        this.clientLibVersion = clientLibVersion;
        this.generatorName = generatorName;
        this.generatorVersion = generatorVersion;
        this.apiClientHeaderLineData = apiClientHeaderLineData;
        this.googleCloudResourcePrefix = googleCloudResourcePrefix;
        this.headers = this.generateHeaders();
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    private Map<String, String> generateHeaders() {
        ImmutableMap.Builder headers = ImmutableMap.builder();
        headers.put((Object)this.apiClientHeaderLineKey, (Object)this.getApiClientHeaderLineData());
        if (this.googleCloudResourcePrefix != null) {
            headers.put((Object)"google-cloud-resource-prefix", (Object)this.googleCloudResourcePrefix);
        }
        return headers.build();
    }

    private String getApiClientHeaderLineData() {
        ArrayList headerLineParts = Lists.newArrayList();
        headerLineParts.add("gl-java/" + ApiClientHeaderProvider.getJavaVersion());
        if (this.clientLibName != null && this.clientLibVersion != null) {
            headerLineParts.add(this.clientLibName + "/" + this.clientLibVersion);
        }
        headerLineParts.add(this.generatorName + "/" + this.generatorVersion);
        headerLineParts.add("gax/" + GaxProperties.getGaxVersion());
        headerLineParts.addAll(this.apiClientHeaderLineData);
        return Joiner.on((String)" ").join((Iterable)headerLineParts);
    }

    private static String getJavaVersion() {
        String javaVersion = Runtime.class.getPackage().getImplementationVersion();
        if (javaVersion == null) {
            javaVersion = DEFAULT_VERSION;
        }
        return javaVersion;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private static final String DEFAULT_GENERATOR_NAME = "gapic";
        private String apiClientHeaderLineKey;
        private String clientLibName;
        private String clientLibVersion;
        private String generatorName;
        private String generatorVersion;
        private List<String> apiClientHeaderLineData = new ArrayList<String>();
        private String googleCloudResourcePrefix;

        private Builder() {
            this.generatorName = DEFAULT_GENERATOR_NAME;
            this.generatorVersion = ApiClientHeaderProvider.DEFAULT_VERSION;
        }

        private Builder(ApiClientHeaderProvider provider) {
            this.apiClientHeaderLineKey = provider.apiClientHeaderLineKey;
            this.clientLibName = provider.clientLibName;
            this.clientLibVersion = provider.clientLibVersion;
            this.generatorName = provider.generatorName;
            this.generatorVersion = provider.generatorVersion;
            this.apiClientHeaderLineData = provider.apiClientHeaderLineData;
            this.googleCloudResourcePrefix = provider.googleCloudResourcePrefix;
        }

        public Builder setApiClientHeaderLineKey(String key) {
            this.apiClientHeaderLineKey = key;
            return this;
        }

        public Builder setClientLibHeader(String name, String version) {
            this.clientLibName = name;
            this.clientLibVersion = version;
            return this;
        }

        public Builder setGeneratorHeader(String name, String version) {
            this.generatorName = name;
            this.generatorVersion = version;
            return this;
        }

        public Builder addApiClientHeaderLineData(List<String> data) {
            for (String datum : data) {
                Preconditions.checkArgument((boolean)datum.contains("/"));
            }
            this.apiClientHeaderLineData.addAll(data);
            return this;
        }

        @BetaApi(value="This API and its semantics are likely to change in the future.")
        public Builder setGoogleCloudResourcePrefix(String resourcePrefix) {
            this.googleCloudResourcePrefix = resourcePrefix;
            return this;
        }

        public String getApiClientHeaderLineKey() {
            return this.apiClientHeaderLineKey;
        }

        public String getClientLibName() {
            return this.clientLibName;
        }

        public String getClientLibVersion() {
            return this.clientLibVersion;
        }

        public String getGeneratorName() {
            return this.generatorName;
        }

        public String getGeneratorVersion() {
            return this.generatorVersion;
        }

        public List<String> getApiClientHeaderLineData() {
            return this.apiClientHeaderLineData;
        }

        @BetaApi(value="This API and its semantics are likely to change in the future.")
        public String getGoogleCloudResourcePrefixHeader() {
            return this.googleCloudResourcePrefix;
        }

        public ApiClientHeaderProvider build() {
            return new ApiClientHeaderProvider(this.apiClientHeaderLineKey, this.clientLibName, this.clientLibVersion, this.generatorName, this.generatorVersion, this.apiClientHeaderLineData, this.googleCloudResourcePrefix);
        }
    }
}

