/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.NanoClock;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.NoHeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;

@BetaApi
public abstract class ClientSettings {
    private final ExecutorProvider executorProvider;
    private final CredentialsProvider credentialsProvider;
    private final HeaderProvider headerProvider;
    private final TransportChannelProvider transportChannelProvider;
    private final ApiClock clock;

    protected ClientSettings(ExecutorProvider executorProvider, TransportChannelProvider transportChannelProvider, CredentialsProvider credentialsProvider, HeaderProvider headerProvider, ApiClock clock) {
        this.executorProvider = executorProvider;
        this.transportChannelProvider = transportChannelProvider;
        this.credentialsProvider = credentialsProvider;
        this.headerProvider = headerProvider;
        this.clock = clock;
    }

    public final ExecutorProvider getExecutorProvider() {
        return this.executorProvider;
    }

    public final TransportChannelProvider getTransportChannelProvider() {
        return this.transportChannelProvider;
    }

    public final CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public final HeaderProvider getHeaderProvider() {
        return this.headerProvider;
    }

    public final ApiClock getClock() {
        return this.clock;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("executorProvider", (Object)this.executorProvider).add("transportChannelProvider", (Object)this.transportChannelProvider).add("credentialsProvider", (Object)this.credentialsProvider).add("headerProvider", (Object)this.headerProvider).add("clock", (Object)this.clock).toString();
    }

    public static abstract class Builder {
        private ExecutorProvider executorProvider;
        private CredentialsProvider credentialsProvider;
        private HeaderProvider headerProvider;
        private TransportChannelProvider transportChannelProvider;
        private ApiClock clock;

        protected Builder(ClientSettings settings) {
            this.executorProvider = settings.executorProvider;
            this.transportChannelProvider = settings.transportChannelProvider;
            this.credentialsProvider = settings.credentialsProvider;
            this.headerProvider = settings.headerProvider;
            this.clock = settings.clock;
        }

        protected Builder(ClientContext clientContext) {
            if (clientContext == null) {
                this.executorProvider = InstantiatingExecutorProvider.newBuilder().build();
                this.transportChannelProvider = null;
                this.credentialsProvider = NoCredentialsProvider.create();
                this.headerProvider = new NoHeaderProvider();
                this.clock = NanoClock.getDefaultClock();
            } else {
                this.executorProvider = FixedExecutorProvider.create(clientContext.getExecutor());
                this.transportChannelProvider = FixedTransportChannelProvider.create(clientContext.getTransportChannel());
                this.credentialsProvider = FixedCredentialsProvider.create(clientContext.getCredentials());
                this.headerProvider = FixedHeaderProvider.create(clientContext.getHeaders());
                this.clock = clientContext.getClock();
            }
        }

        protected Builder() {
            this((ClientContext)null);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = executorProvider;
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider);
            return this;
        }

        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = headerProvider;
            return this;
        }

        public Builder setTransportChannelProvider(TransportChannelProvider transportChannelProvider) {
            this.transportChannelProvider = transportChannelProvider;
            return this;
        }

        public Builder setClock(ApiClock clock) {
            this.clock = clock;
            return this;
        }

        public ExecutorProvider getExecutorProvider() {
            return this.executorProvider;
        }

        public TransportChannelProvider getTransportChannelProvider() {
            return this.transportChannelProvider;
        }

        public CredentialsProvider getCredentialsProvider() {
            return this.credentialsProvider;
        }

        public HeaderProvider getHeaderProvider() {
            return this.headerProvider;
        }

        public ApiClock getClock() {
            return this.clock;
        }

        protected static void applyToAllUnaryMethods(Iterable<UnaryCallSettings.Builder<?, ?>> methodSettingsBuilders, ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            for (UnaryCallSettings.Builder<?, ?> settingsBuilder : methodSettingsBuilders) {
                settingsUpdater.apply(settingsBuilder);
            }
        }

        public abstract ClientSettings build() throws IOException;

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("executorProvider", (Object)this.executorProvider).add("transportChannelProvider", (Object)this.transportChannelProvider).add("credentialsProvider", (Object)this.credentialsProvider).add("headerProvider", (Object)this.headerProvider).add("clock", (Object)this.clock).toString();
        }
    }
}

