/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.NanoClock;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.NoHeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;

public abstract class ClientSettings<SettingsT extends ClientSettings<SettingsT>> {
    private final ExecutorProvider executorProvider;
    private final CredentialsProvider credentialsProvider;
    private final HeaderProvider headerProvider;
    private final HeaderProvider internalHeaderProvider;
    private final TransportChannelProvider transportChannelProvider;
    private final ApiClock clock;
    private final String endpoint;

    protected ClientSettings(Builder builder) {
        this.executorProvider = builder.executorProvider;
        this.transportChannelProvider = builder.transportChannelProvider;
        this.credentialsProvider = builder.credentialsProvider;
        this.headerProvider = builder.headerProvider;
        this.internalHeaderProvider = builder.internalHeaderProvider;
        this.clock = builder.clock;
        this.endpoint = builder.endpoint;
    }

    public final ExecutorProvider getExecutorProvider() {
        return this.executorProvider;
    }

    public final TransportChannelProvider getTransportChannelProvider() {
        return this.transportChannelProvider;
    }

    public final CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public final HeaderProvider getHeaderProvider() {
        return this.headerProvider;
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    protected final HeaderProvider getInternalHeaderProvider() {
        return this.internalHeaderProvider;
    }

    public final ApiClock getClock() {
        return this.clock;
    }

    public final String getEndpoint() {
        return this.endpoint;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("executorProvider", (Object)this.executorProvider).add("transportChannelProvider", (Object)this.transportChannelProvider).add("credentialsProvider", (Object)this.credentialsProvider).add("headerProvider", (Object)this.headerProvider).add("internalHeaderProvider", (Object)this.internalHeaderProvider).add("clock", (Object)this.clock).add("endpoint", (Object)this.endpoint).toString();
    }

    public abstract <B extends Builder<SettingsT, B>> B toBuilder();

    public static abstract class Builder<SettingsT extends ClientSettings<SettingsT>, B extends Builder<SettingsT, B>> {
        private ExecutorProvider executorProvider;
        private CredentialsProvider credentialsProvider;
        private HeaderProvider headerProvider;
        private HeaderProvider internalHeaderProvider;
        private TransportChannelProvider transportChannelProvider;
        private ApiClock clock;
        private String endpoint;

        protected Builder(ClientSettings settings) {
            this.executorProvider = settings.executorProvider;
            this.transportChannelProvider = settings.transportChannelProvider;
            this.credentialsProvider = settings.credentialsProvider;
            this.headerProvider = settings.headerProvider;
            this.internalHeaderProvider = settings.internalHeaderProvider;
            this.clock = settings.clock;
            this.endpoint = settings.endpoint;
        }

        protected Builder(ClientContext clientContext) {
            if (clientContext == null) {
                this.executorProvider = InstantiatingExecutorProvider.newBuilder().build();
                this.transportChannelProvider = null;
                this.credentialsProvider = NoCredentialsProvider.create();
                this.headerProvider = new NoHeaderProvider();
                this.internalHeaderProvider = new NoHeaderProvider();
                this.clock = NanoClock.getDefaultClock();
                this.endpoint = null;
            } else {
                this.executorProvider = FixedExecutorProvider.create(clientContext.getExecutor());
                this.transportChannelProvider = FixedTransportChannelProvider.create(clientContext.getTransportChannel());
                this.credentialsProvider = FixedCredentialsProvider.create(clientContext.getCredentials());
                this.headerProvider = FixedHeaderProvider.create(clientContext.getHeaders());
                this.internalHeaderProvider = FixedHeaderProvider.create(clientContext.getInternalHeaders());
                this.clock = clientContext.getClock();
                this.endpoint = clientContext.getEndpoint();
            }
        }

        protected Builder() {
            this((ClientContext)null);
        }

        protected B self() {
            return (B)this;
        }

        public B setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = executorProvider;
            return this.self();
        }

        public B setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider);
            return this.self();
        }

        @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
        public B setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = headerProvider;
            return this.self();
        }

        @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
        protected B setInternalHeaderProvider(HeaderProvider internalHeaderProvider) {
            this.internalHeaderProvider = internalHeaderProvider;
            return this.self();
        }

        public B setTransportChannelProvider(TransportChannelProvider transportChannelProvider) {
            this.transportChannelProvider = transportChannelProvider;
            return this.self();
        }

        public B setClock(ApiClock clock) {
            this.clock = clock;
            return this.self();
        }

        public B setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this.self();
        }

        public ExecutorProvider getExecutorProvider() {
            return this.executorProvider;
        }

        public TransportChannelProvider getTransportChannelProvider() {
            return this.transportChannelProvider;
        }

        public CredentialsProvider getCredentialsProvider() {
            return this.credentialsProvider;
        }

        @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
        public HeaderProvider getHeaderProvider() {
            return this.headerProvider;
        }

        @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
        protected HeaderProvider getInternalHeaderProvider() {
            return this.internalHeaderProvider;
        }

        public ApiClock getClock() {
            return this.clock;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        protected static void applyToAllUnaryMethods(Iterable<UnaryCallSettings.Builder<?, ?>> methodSettingsBuilders, ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            for (UnaryCallSettings.Builder<?, ?> settingsBuilder : methodSettingsBuilders) {
                settingsUpdater.apply(settingsBuilder);
            }
        }

        public abstract SettingsT build() throws IOException;

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("executorProvider", (Object)this.executorProvider).add("transportChannelProvider", (Object)this.transportChannelProvider).add("credentialsProvider", (Object)this.credentialsProvider).add("headerProvider", (Object)this.headerProvider).add("internalHeaderProvider", (Object)this.internalHeaderProvider).add("clock", (Object)this.clock).add("endpoint", (Object)this.endpoint).toString();
        }
    }
}

