/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import com.google.common.base.Preconditions;

final class Semaphore64 {
    private long currentPermits;

    Semaphore64(long permits) {
        Semaphore64.notNegative(permits);
        this.currentPermits = permits;
    }

    synchronized void release(long permits) {
        Semaphore64.notNegative(permits);
        this.currentPermits += permits;
        this.notifyAll();
    }

    synchronized void acquireUninterruptibly(long permits) {
        Semaphore64.notNegative(permits);
        boolean interrupted = false;
        while (this.currentPermits < permits) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        this.currentPermits -= permits;
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    synchronized boolean tryAcquire(long permits) {
        Semaphore64.notNegative(permits);
        if (this.currentPermits >= permits) {
            this.currentPermits -= permits;
            return true;
        }
        return false;
    }

    private static void notNegative(long l) {
        Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0, (String)"negative permits not allowed: %s", (Object[])new Object[]{l});
    }
}

