/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.gax.core.AutoValue_InstantiatingExecutorProvider;
import com.google.api.gax.core.ExecutorProvider;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public abstract class InstantiatingExecutorProvider
implements ExecutorProvider {
    private static final int DEFAULT_EXECUTOR_THREADS = 4;

    InstantiatingExecutorProvider() {
    }

    @Override
    public ScheduledExecutorService getExecutor() {
        return new ScheduledThreadPoolExecutor(this.getExecutorThreadCount(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            }
        });
    }

    @Override
    public boolean shouldAutoClose() {
        return true;
    }

    public abstract int getExecutorThreadCount();

    public Builder toBuilder() {
        return new AutoValue_InstantiatingExecutorProvider.Builder(this);
    }

    public static Builder newBuilder() {
        return new AutoValue_InstantiatingExecutorProvider.Builder().setExecutorThreadCount(4);
    }

    public static abstract class Builder {
        public abstract Builder setExecutorThreadCount(int var1);

        public abstract int getExecutorThreadCount();

        public abstract InstantiatingExecutorProvider build();
    }
}

