/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import com.google.api.core.BetaApi;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.Semaphore64;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

@BetaApi
public class FlowController {
    @Nullable
    private final Semaphore64 outstandingElementCount;
    @Nullable
    private final Semaphore64 outstandingByteCount;
    private final boolean failOnLimits;
    @Nullable
    private final Long maxOutstandingElementCount;
    @Nullable
    private final Long maxOutstandingRequestBytes;

    public FlowController(FlowControlSettings settings) {
        switch (settings.getLimitExceededBehavior()) {
            case ThrowException: {
                this.failOnLimits = true;
                break;
            }
            case Block: {
                this.failOnLimits = false;
                break;
            }
            case Ignore: {
                this.failOnLimits = false;
                this.maxOutstandingElementCount = null;
                this.maxOutstandingRequestBytes = null;
                this.outstandingElementCount = null;
                this.outstandingByteCount = null;
                return;
            }
            default: {
                throw new IllegalArgumentException("Unknown LimitBehaviour: " + (Object)((Object)settings.getLimitExceededBehavior()));
            }
        }
        this.maxOutstandingElementCount = settings.getMaxOutstandingElementCount();
        this.maxOutstandingRequestBytes = settings.getMaxOutstandingRequestBytes();
        this.outstandingElementCount = this.maxOutstandingElementCount != null ? new Semaphore64(this.maxOutstandingElementCount) : null;
        this.outstandingByteCount = this.maxOutstandingRequestBytes != null ? new Semaphore64(this.maxOutstandingRequestBytes) : null;
    }

    public void reserve(long elements, long bytes) throws FlowControlException {
        Preconditions.checkArgument((elements >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0);
        if (this.outstandingElementCount != null) {
            if (!this.failOnLimits) {
                this.outstandingElementCount.acquireUninterruptibly(elements);
            } else if (!this.outstandingElementCount.tryAcquire(elements)) {
                throw new MaxOutstandingElementCountReachedException(this.maxOutstandingElementCount);
            }
        }
        if (this.outstandingByteCount != null) {
            long permitsToDraw = Math.min(bytes, this.maxOutstandingRequestBytes);
            if (!this.failOnLimits) {
                this.outstandingByteCount.acquireUninterruptibly(permitsToDraw);
            } else if (!this.outstandingByteCount.tryAcquire(permitsToDraw)) {
                if (this.outstandingElementCount != null) {
                    this.outstandingElementCount.release(elements);
                }
                throw new MaxOutstandingRequestBytesReachedException(this.maxOutstandingRequestBytes);
            }
        }
    }

    public void release(long elements, long bytes) {
        Preconditions.checkArgument((elements >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0);
        if (this.outstandingElementCount != null) {
            this.outstandingElementCount.release(elements);
        }
        if (this.outstandingByteCount != null) {
            long permitsToReturn = Math.min(bytes, this.maxOutstandingRequestBytes);
            this.outstandingByteCount.release(permitsToReturn);
        }
    }

    @BetaApi
    public static enum LimitExceededBehavior {
        ThrowException,
        Block,
        Ignore;

    }

    @BetaApi
    public static final class MaxOutstandingRequestBytesReachedException
    extends FlowControlException {
        private final long currentMaxBytes;

        public MaxOutstandingRequestBytesReachedException(long currentMaxBytes) {
            this.currentMaxBytes = currentMaxBytes;
        }

        public long getCurrentMaxBatchBytes() {
            return this.currentMaxBytes;
        }

        @Override
        public String toString() {
            return String.format("The maximum number of batch bytes: %d have been reached.", this.currentMaxBytes);
        }
    }

    @BetaApi
    public static final class MaxOutstandingElementCountReachedException
    extends FlowControlException {
        private final long currentMaxElementCount;

        public MaxOutstandingElementCountReachedException(long currentMaxElementCount) {
            this.currentMaxElementCount = currentMaxElementCount;
        }

        public long getCurrentMaxBatchElementCount() {
            return this.currentMaxElementCount;
        }

        @Override
        public String toString() {
            return String.format("The maximum number of batch elements: %d have been reached.", this.currentMaxElementCount);
        }
    }

    @BetaApi
    public static class FlowControlRuntimeException
    extends RuntimeException {
        private FlowControlRuntimeException(FlowControlException e) {
            super(e);
        }

        public static FlowControlRuntimeException fromFlowControlException(FlowControlException e) {
            return new FlowControlRuntimeException(e);
        }
    }

    public static abstract class FlowControlException
    extends Exception {
        private FlowControlException() {
        }
    }
}

