/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.core.ApiClock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class FakeApiClock
implements ApiClock {
    private final AtomicLong currentNanoTime;

    public FakeApiClock(long initialNanoTime) {
        this.currentNanoTime = new AtomicLong(initialNanoTime);
    }

    public long nanoTime() {
        return this.currentNanoTime.get();
    }

    public long millisTime() {
        return TimeUnit.MILLISECONDS.convert(this.nanoTime(), TimeUnit.NANOSECONDS);
    }

    public void incrementNanoTime(long delta) {
        this.currentNanoTime.getAndAdd(delta);
    }
}

