/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.retrying;

import com.google.api.core.ApiClock;
import com.google.api.gax.core.FakeApiClock;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedAttemptSettings;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class ExponentialRetryAlgorithmTest {
    private final FakeApiClock clock = new FakeApiClock(0L);
    private final RetrySettings retrySettings = RetrySettings.newBuilder().setMaxAttempts(6).setInitialRetryDelay(Duration.ofMillis((long)1L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)8L)).setInitialRpcTimeout(Duration.ofMillis((long)1L)).setJittered(false).setRpcTimeoutMultiplier(2.0).setMaxRpcTimeout(Duration.ofMillis((long)8L)).setTotalTimeout(Duration.ofMillis((long)200L)).build();
    private final ExponentialRetryAlgorithm algorithm = new ExponentialRetryAlgorithm(this.retrySettings, (ApiClock)this.clock);

    @Test
    public void testCreateFirstAttempt() {
        TimedAttemptSettings attempt = this.algorithm.createFirstAttempt();
        Assert.assertEquals((long)0L, (long)attempt.getAttemptCount());
        Assert.assertEquals((Object)Duration.ZERO, (Object)attempt.getRetryDelay());
        Assert.assertEquals((Object)Duration.ZERO, (Object)attempt.getRandomizedRetryDelay());
        Assert.assertEquals((Object)Duration.ofMillis((long)1L), (Object)attempt.getRpcTimeout());
        Assert.assertEquals((Object)Duration.ZERO, (Object)attempt.getRetryDelay());
    }

    @Test
    public void testCreateNextAttempt() {
        TimedAttemptSettings firstAttempt = this.algorithm.createFirstAttempt();
        TimedAttemptSettings secondAttempt = this.algorithm.createNextAttempt(firstAttempt);
        Assert.assertEquals((long)1L, (long)secondAttempt.getAttemptCount());
        Assert.assertEquals((Object)Duration.ofMillis((long)1L), (Object)secondAttempt.getRetryDelay());
        Assert.assertEquals((Object)Duration.ofMillis((long)1L), (Object)secondAttempt.getRandomizedRetryDelay());
        Assert.assertEquals((Object)Duration.ofMillis((long)2L), (Object)secondAttempt.getRpcTimeout());
        TimedAttemptSettings thirdAttempt = this.algorithm.createNextAttempt(secondAttempt);
        Assert.assertEquals((long)2L, (long)thirdAttempt.getAttemptCount());
        Assert.assertEquals((Object)Duration.ofMillis((long)2L), (Object)thirdAttempt.getRetryDelay());
        Assert.assertEquals((Object)Duration.ofMillis((long)2L), (Object)thirdAttempt.getRandomizedRetryDelay());
        Assert.assertEquals((Object)Duration.ofMillis((long)4L), (Object)thirdAttempt.getRpcTimeout());
    }

    @Test
    public void testShouldRetryTrue() {
        TimedAttemptSettings attempt = this.algorithm.createFirstAttempt();
        for (int i = 0; i < 2; ++i) {
            attempt = this.algorithm.createNextAttempt(attempt);
        }
        Assert.assertTrue((boolean)this.algorithm.shouldRetry(attempt));
    }

    @Test
    public void testShouldRetryFalseOnMaxAttempts() {
        TimedAttemptSettings attempt = this.algorithm.createFirstAttempt();
        for (int i = 0; i < 6; ++i) {
            Assert.assertTrue((boolean)this.algorithm.shouldRetry(attempt));
            attempt = this.algorithm.createNextAttempt(attempt);
        }
        Assert.assertFalse((boolean)this.algorithm.shouldRetry(attempt));
    }

    @Test
    public void testShouldRetryFalseOnMaxTimeout() {
        TimedAttemptSettings attempt = this.algorithm.createFirstAttempt();
        for (int i = 0; i < 4; ++i) {
            Assert.assertTrue((boolean)this.algorithm.shouldRetry(attempt));
            attempt = this.algorithm.createNextAttempt(attempt);
            this.clock.incrementNanoTime(Duration.ofMillis((long)50L).toNanos());
        }
        Assert.assertFalse((boolean)this.algorithm.shouldRetry(attempt));
    }
}

