/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.testing;

import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.internal.Headers;
import com.google.api.gax.rpc.testing.FakeChannel;
import com.google.api.gax.rpc.testing.FakeTransportChannel;
import com.google.auth.Credentials;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

@InternalApi(value="for testing")
public class FakeCallContext
implements ApiCallContext {
    private final Credentials credentials;
    private final FakeChannel channel;
    private final Duration timeout;
    private final Duration streamWaitTimeout;
    private final Duration streamIdleTimeout;
    private final ImmutableMap<String, List<String>> extraHeaders;

    private FakeCallContext(Credentials credentials, FakeChannel channel, Duration timeout, Duration streamWaitTimeout, Duration streamIdleTimeout, ImmutableMap<String, List<String>> extraHeaders) {
        this.credentials = credentials;
        this.channel = channel;
        this.timeout = timeout;
        this.streamWaitTimeout = streamWaitTimeout;
        this.streamIdleTimeout = streamIdleTimeout;
        this.extraHeaders = extraHeaders;
    }

    public static FakeCallContext createDefault() {
        return new FakeCallContext(null, null, null, null, null, (ImmutableMap<String, List<String>>)ImmutableMap.of());
    }

    public FakeCallContext nullToSelf(ApiCallContext inputContext) {
        FakeCallContext fakeCallContext;
        if (inputContext == null) {
            fakeCallContext = this;
        } else {
            if (!(inputContext instanceof FakeCallContext)) {
                throw new IllegalArgumentException("context must be an instance of FakeCallContext, but found " + inputContext.getClass().getName());
            }
            fakeCallContext = (FakeCallContext)inputContext;
        }
        return fakeCallContext;
    }

    public ApiCallContext merge(ApiCallContext inputCallContext) {
        Duration newStreamIdleTimeout;
        Duration newStreamWaitTimeout;
        Duration newTimeout;
        Credentials newCallCredentials;
        if (inputCallContext == null) {
            return this;
        }
        if (!(inputCallContext instanceof FakeCallContext)) {
            throw new IllegalArgumentException("context must be an instance of FakeCallContext, but found " + inputCallContext.getClass().getName());
        }
        FakeCallContext fakeCallContext = (FakeCallContext)inputCallContext;
        FakeChannel newChannel = fakeCallContext.channel;
        if (newChannel == null) {
            newChannel = this.channel;
        }
        if ((newCallCredentials = fakeCallContext.credentials) == null) {
            newCallCredentials = this.credentials;
        }
        if ((newTimeout = fakeCallContext.timeout) == null) {
            newTimeout = this.timeout;
        }
        if ((newStreamWaitTimeout = fakeCallContext.streamWaitTimeout) == null) {
            newStreamWaitTimeout = this.streamWaitTimeout;
        }
        if ((newStreamIdleTimeout = fakeCallContext.streamIdleTimeout) == null) {
            newStreamIdleTimeout = this.streamIdleTimeout;
        }
        ImmutableMap newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, fakeCallContext.extraHeaders);
        return new FakeCallContext(newCallCredentials, newChannel, newTimeout, newStreamWaitTimeout, newStreamIdleTimeout, (ImmutableMap<String, List<String>>)newExtraHeaders);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public FakeChannel getChannel() {
        return this.channel;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    @Nullable
    public Duration getStreamWaitTimeout() {
        return this.streamWaitTimeout;
    }

    @Nullable
    public Duration getStreamIdleTimeout() {
        return this.streamIdleTimeout;
    }

    public FakeCallContext withCredentials(Credentials credentials) {
        return new FakeCallContext(credentials, this.channel, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders);
    }

    public FakeCallContext withTransportChannel(TransportChannel inputChannel) {
        Preconditions.checkNotNull((Object)inputChannel);
        if (!(inputChannel instanceof FakeTransportChannel)) {
            throw new IllegalArgumentException("Expected FakeTransportChannel, got " + inputChannel.getClass().getName());
        }
        FakeTransportChannel transportChannel = (FakeTransportChannel)inputChannel;
        return this.withChannel(transportChannel.getChannel());
    }

    public FakeCallContext withChannel(FakeChannel channel) {
        return new FakeCallContext(this.credentials, channel, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders);
    }

    public FakeCallContext withTimeout(Duration timeout) {
        if (timeout != null && (timeout.isZero() || timeout.isNegative())) {
            timeout = null;
        }
        if (timeout != null && this.timeout != null && this.timeout.compareTo(timeout) <= 0) {
            return this;
        }
        return new FakeCallContext(this.credentials, this.channel, timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders);
    }

    public ApiCallContext withStreamWaitTimeout(@Nonnull Duration streamWaitTimeout) {
        Preconditions.checkNotNull((Object)streamWaitTimeout);
        return new FakeCallContext(this.credentials, this.channel, this.timeout, streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders);
    }

    public ApiCallContext withStreamIdleTimeout(@Nonnull Duration streamIdleTimeout) {
        Preconditions.checkNotNull((Object)streamIdleTimeout);
        return new FakeCallContext(this.credentials, this.channel, this.timeout, this.streamWaitTimeout, streamIdleTimeout, this.extraHeaders);
    }

    public ApiCallContext withExtraHeaders(Map<String, List<String>> extraHeaders) {
        Preconditions.checkNotNull(extraHeaders);
        ImmutableMap newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, extraHeaders);
        return new FakeCallContext(this.credentials, this.channel, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, (ImmutableMap<String, List<String>>)newExtraHeaders);
    }

    public Map<String, List<String>> getExtraHeaders() {
        return this.extraHeaders;
    }

    public static FakeCallContext create(ClientContext clientContext) {
        return FakeCallContext.createDefault().withTransportChannel(clientContext.getTransportChannel()).withCredentials(clientContext.getCredentials());
    }
}

