/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiFuture;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.batching.TrackedFlowController;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.BatchingCallSettings;
import com.google.api.gax.rpc.BatchingDescriptor;
import com.google.api.gax.rpc.Callables;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RetryingTest;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeBatchableApi;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakeCallableFactory;
import com.google.api.gax.rpc.testing.FakeChannel;
import com.google.api.gax.rpc.testing.FakeTransportChannel;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class BatchingTest {
    private ScheduledExecutorService batchingExecutor;
    private ClientContext clientContext;
    private static UnaryCallable<FakeBatchableApi.LabeledIntList, List<Integer>> callLabeledIntExceptionThrower = new UnaryCallable<FakeBatchableApi.LabeledIntList, List<Integer>>(){

        public ApiFuture<List<Integer>> futureCall(FakeBatchableApi.LabeledIntList request, ApiCallContext context) {
            return RetryingTest.immediateFailedFuture(new IllegalArgumentException("I FAIL!!"));
        }
    };

    @Before
    public void setUp() {
        this.batchingExecutor = new ScheduledThreadPoolExecutor(1);
        this.clientContext = ClientContext.newBuilder().setExecutor(this.batchingExecutor).setDefaultCallContext((ApiCallContext)FakeCallContext.createDefault()).setTransportChannel((TransportChannel)FakeTransportChannel.create(new FakeChannel())).build();
    }

    @After
    public void teardown() {
        this.batchingExecutor.shutdownNow();
    }

    @Test
    public void batching() throws Exception {
        BatchingSettings batchingSettings = BatchingSettings.newBuilder().setDelayThreshold(Duration.ofSeconds((long)1L)).setElementCountThreshold(Long.valueOf(2L)).build();
        BatchingCallSettings batchingCallSettings = BatchingCallSettings.newBuilder((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC).setBatchingSettings(batchingSettings).build();
        UnaryCallable<FakeBatchableApi.LabeledIntList, List<Integer>> callable = FakeCallableFactory.createBatchingCallable(FakeBatchableApi.callLabeledIntSquarer, batchingCallSettings, this.clientContext);
        ApiFuture f1 = callable.futureCall((Object)new FakeBatchableApi.LabeledIntList("one", 1, 2));
        ApiFuture f2 = callable.futureCall((Object)new FakeBatchableApi.LabeledIntList("one", 3, 4));
        Truth.assertThat((Iterable)((Iterable)f1.get())).isEqualTo(Arrays.asList(1, 4));
        Truth.assertThat((Iterable)((Iterable)f2.get())).isEqualTo(Arrays.asList(9, 16));
    }

    @Test
    public void batchingWithFlowControl() throws Exception {
        BatchingSettings batchingSettings = BatchingSettings.newBuilder().setDelayThreshold(Duration.ofSeconds((long)1L)).setElementCountThreshold(Long.valueOf(4L)).setRequestByteThreshold(null).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).setMaxOutstandingElementCount(Long.valueOf(10L)).setMaxOutstandingRequestBytes(Long.valueOf(10L)).build()).build();
        TrackedFlowController trackedFlowController = new TrackedFlowController(batchingSettings.getFlowControlSettings());
        Truth.assertThat((Long)trackedFlowController.getElementsReserved()).isEqualTo((Object)0);
        Truth.assertThat((Long)trackedFlowController.getElementsReleased()).isEqualTo((Object)0);
        Truth.assertThat((Long)trackedFlowController.getBytesReserved()).isEqualTo((Object)0);
        Truth.assertThat((Long)trackedFlowController.getBytesReleased()).isEqualTo((Object)0);
        Truth.assertThat((Integer)trackedFlowController.getCallsToReserve()).isEqualTo((Object)0);
        Truth.assertThat((Integer)trackedFlowController.getCallsToRelease()).isEqualTo((Object)0);
        FakeBatchableApi.LabeledIntList requestA = new FakeBatchableApi.LabeledIntList("one", 1, 2);
        FakeBatchableApi.LabeledIntList requestB = new FakeBatchableApi.LabeledIntList("one", 3, 4);
        BatchingCallSettings batchingCallSettings = BatchingCallSettings.newBuilder((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC).setBatchingSettings(batchingSettings).setFlowController((FlowController)trackedFlowController).build();
        Callables.BatchingCreateResult batchingCreateResult = Callables.batchingImpl((UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (BatchingCallSettings)batchingCallSettings, (ClientContext)this.clientContext);
        ApiFuture f1 = batchingCreateResult.getUnaryCallable().futureCall((Object)requestA, (ApiCallContext)FakeCallContext.createDefault());
        ApiFuture f2 = batchingCreateResult.getUnaryCallable().futureCall((Object)requestB, (ApiCallContext)FakeCallContext.createDefault());
        Truth.assertThat((Iterable)((Iterable)f1.get())).isEqualTo(Arrays.asList(1, 4));
        Truth.assertThat((Iterable)((Iterable)f2.get())).isEqualTo(Arrays.asList(9, 16));
        batchingCreateResult.getBatcherFactory().getPushingBatcher(FakeBatchableApi.SQUARER_BATCHING_DESC.getBatchPartitionKey(requestA)).pushCurrentBatch().get();
        Truth.assertThat((Long)trackedFlowController.getElementsReserved()).isEqualTo((Object)4);
        Truth.assertThat((Long)trackedFlowController.getElementsReleased()).isEqualTo((Object)4);
        Truth.assertThat((Long)trackedFlowController.getBytesReserved()).isEqualTo((Object)8);
        Truth.assertThat((Long)trackedFlowController.getBytesReleased()).isEqualTo((Object)8);
        Truth.assertThat((Integer)trackedFlowController.getCallsToReserve()).isEqualTo((Object)2);
        Truth.assertThat((Integer)trackedFlowController.getCallsToRelease()).isEqualTo((Object)1);
    }

    @Test
    public void batchingDisabled() throws Exception {
        BatchingSettings batchingSettings = BatchingSettings.newBuilder().setIsEnabled(Boolean.valueOf(false)).build();
        BatchingCallSettings batchingCallSettings = BatchingCallSettings.newBuilder((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC).setBatchingSettings(batchingSettings).build();
        UnaryCallable<FakeBatchableApi.LabeledIntList, List<Integer>> callable = FakeCallableFactory.createBatchingCallable(FakeBatchableApi.callLabeledIntSquarer, batchingCallSettings, this.clientContext);
        ApiFuture f1 = callable.futureCall((Object)new FakeBatchableApi.LabeledIntList("one", 1, 2));
        ApiFuture f2 = callable.futureCall((Object)new FakeBatchableApi.LabeledIntList("one", 3, 4));
        Truth.assertThat((Iterable)((Iterable)f1.get())).isEqualTo(Arrays.asList(1, 4));
        Truth.assertThat((Iterable)((Iterable)f2.get())).isEqualTo(Arrays.asList(9, 16));
    }

    public void batchingWithBlockingCallThreshold() throws Exception {
        BatchingSettings batchingSettings = BatchingSettings.newBuilder().setDelayThreshold(Duration.ofSeconds((long)1L)).setElementCountThreshold(Long.valueOf(2L)).build();
        BatchingCallSettings batchingCallSettings = BatchingCallSettings.newBuilder((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC).setBatchingSettings(batchingSettings).build();
        UnaryCallable<FakeBatchableApi.LabeledIntList, List<Integer>> callable = FakeCallableFactory.createBatchingCallable(FakeBatchableApi.callLabeledIntSquarer, batchingCallSettings, this.clientContext);
        ApiFuture f1 = callable.futureCall((Object)new FakeBatchableApi.LabeledIntList("one", 1));
        ApiFuture f2 = callable.futureCall((Object)new FakeBatchableApi.LabeledIntList("one", 3));
        Truth.assertThat((Iterable)((Iterable)f1.get())).isEqualTo(Arrays.asList(1));
        Truth.assertThat((Iterable)((Iterable)f2.get())).isEqualTo(Arrays.asList(9));
    }

    @Test
    public void batchingException() throws Exception {
        BatchingSettings batchingSettings = BatchingSettings.newBuilder().setDelayThreshold(Duration.ofSeconds((long)1L)).setElementCountThreshold(Long.valueOf(2L)).build();
        BatchingCallSettings batchingCallSettings = BatchingCallSettings.newBuilder((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC).setBatchingSettings(batchingSettings).build();
        UnaryCallable<FakeBatchableApi.LabeledIntList, List<Integer>> callable = FakeCallableFactory.createBatchingCallable(callLabeledIntExceptionThrower, batchingCallSettings, this.clientContext);
        ApiFuture f1 = callable.futureCall((Object)new FakeBatchableApi.LabeledIntList("one", 1, 2));
        ApiFuture f2 = callable.futureCall((Object)new FakeBatchableApi.LabeledIntList("one", 3, 4));
        try {
            f1.get();
            Assert.fail((String)"Expected exception from batching call");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        try {
            f2.get();
            Assert.fail((String)"Expected exception from batching call");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }
}

