/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.CheckingAttemptCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.threeten.bp.Duration;

@RunWith(value=MockitoJUnitRunner.class)
public class CheckingAttemptCallableTest {
    @Mock
    UnaryCallable<String, String> mockInnerCallable;
    ArgumentCaptor<ApiCallContext> capturedCallContext;
    @Mock
    RetryingFuture<String> mockExternalFuture;
    TimedAttemptSettings currentAttemptSettings;

    @Before
    public void setUp() {
        this.capturedCallContext = ArgumentCaptor.forClass(ApiCallContext.class);
        Mockito.when((Object)this.mockInnerCallable.futureCall(Mockito.any(), (ApiCallContext)this.capturedCallContext.capture())).thenReturn((Object)SettableApiFuture.create());
        this.currentAttemptSettings = TimedAttemptSettings.newBuilder().setGlobalSettings(RetrySettings.newBuilder().build()).setAttemptCount(0).setOverallAttemptCount(0).setFirstAttemptStartTimeNanos(0L).setRetryDelay(Duration.ofSeconds((long)1L)).setRandomizedRetryDelay(Duration.ofSeconds((long)1L)).setRpcTimeout(Duration.ZERO).build();
        Mockito.when((Object)this.mockExternalFuture.getAttemptSettings()).thenAnswer((Answer)new Answer<TimedAttemptSettings>(){

            public TimedAttemptSettings answer(InvocationOnMock invocation) throws Throwable {
                return CheckingAttemptCallableTest.this.currentAttemptSettings;
            }
        });
    }

    @Test
    public void testRpcTimeout() {
        CheckingAttemptCallable callable = new CheckingAttemptCallable(this.mockInnerCallable, (ApiCallContext)FakeCallContext.createDefault());
        callable.setExternalFuture(this.mockExternalFuture);
        Duration timeout = Duration.ofSeconds((long)10L);
        this.currentAttemptSettings = this.currentAttemptSettings.toBuilder().setRpcTimeout(timeout).build();
        callable.call();
        Truth.assertThat((Comparable)((ApiCallContext)this.capturedCallContext.getValue()).getTimeout()).isEqualTo((Object)timeout);
        Duration longerTimeout = Duration.ofSeconds((long)20L);
        this.currentAttemptSettings = this.currentAttemptSettings.toBuilder().setRpcTimeout(longerTimeout).build();
        callable.call();
        Truth.assertThat((Comparable)((ApiCallContext)this.capturedCallContext.getValue()).getTimeout()).isEqualTo((Object)longerTimeout);
    }
}

