/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiClock;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.FixedWatchdogProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.Watchdog;
import com.google.api.gax.rpc.testing.FakeChannel;
import com.google.api.gax.rpc.testing.FakeClientSettings;
import com.google.api.gax.rpc.testing.FakeTransportChannel;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class ClientContextTest {
    @Test
    public void testNoAutoCloseContextNeedsNoExecutor() throws Exception {
        this.runTest(false, false, false, false);
    }

    @Test
    public void testWithAutoCloseContextNeedsNoExecutor() throws Exception {
        this.runTest(true, false, false, false);
    }

    @Test
    public void testWithAutoCloseContextNeedsExecutor() throws Exception {
        this.runTest(true, true, false, false);
    }

    @Test
    public void testNeedsHeaders() throws Exception {
        this.runTest(false, false, true, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNeedsHeadersCollision() throws Exception {
        this.runTest(false, false, true, true);
    }

    private void runTest(boolean shouldAutoClose, boolean contextNeedsExecutor, boolean needHeaders, boolean headersCollision) throws Exception {
        FakeClientSettings.Builder builder = new FakeClientSettings.Builder();
        InterceptingExecutor executor = new InterceptingExecutor(1);
        FakeExecutorProvider executorProvider = new FakeExecutorProvider(executor, shouldAutoClose);
        ImmutableMap headers = ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2");
        FakeTransportChannel transportChannel = FakeTransportChannel.create(new FakeChannel());
        FakeTransportProvider transportProvider = new FakeTransportProvider(transportChannel, contextNeedsExecutor ? null : executor, shouldAutoClose, (Map<String, String>)(needHeaders ? null : headers));
        Credentials credentials = (Credentials)Mockito.mock(Credentials.class);
        ApiClock clock = (ApiClock)Mockito.mock(ApiClock.class);
        Watchdog watchdog = (Watchdog)Mockito.mock(Watchdog.class);
        Duration watchdogCheckInterval = Duration.ofSeconds((long)11L);
        builder.setExecutorProvider(executorProvider);
        builder.setTransportChannelProvider(transportProvider);
        builder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentials));
        builder.setWatchdogProvider(FixedWatchdogProvider.create((Watchdog)watchdog));
        builder.setWatchdogCheckInterval(watchdogCheckInterval);
        builder.setClock(clock);
        HeaderProvider headerProvider = (HeaderProvider)Mockito.mock(HeaderProvider.class);
        Mockito.when((Object)headerProvider.getHeaders()).thenReturn((Object)ImmutableMap.of((Object)"k1", (Object)"v1"));
        HeaderProvider internalHeaderProvider = (HeaderProvider)Mockito.mock(HeaderProvider.class);
        if (headersCollision) {
            Mockito.when((Object)internalHeaderProvider.getHeaders()).thenReturn((Object)ImmutableMap.of((Object)"k1", (Object)"v1"));
        } else {
            Mockito.when((Object)internalHeaderProvider.getHeaders()).thenReturn((Object)ImmutableMap.of((Object)"k2", (Object)"v2"));
        }
        builder.setHeaderProvider(headerProvider);
        builder.setInternalHeaderProvider(internalHeaderProvider);
        FakeClientSettings settings = builder.build();
        ClientContext clientContext = ClientContext.create((ClientSettings)settings);
        Truth.assertThat((Object)clientContext.getExecutor()).isSameAs((Object)executor);
        Truth.assertThat((Object)clientContext.getTransportChannel()).isSameAs((Object)transportChannel);
        FakeTransportChannel actualChannel = (FakeTransportChannel)clientContext.getTransportChannel();
        assert (actualChannel != null);
        Truth.assertThat(actualChannel.getHeaders()).isEqualTo((Object)headers);
        Truth.assertThat((Object)clientContext.getCredentials()).isSameAs((Object)credentials);
        Truth.assertThat((Object)clientContext.getClock()).isSameAs((Object)clock);
        Truth.assertThat((Object)clientContext.getStreamWatchdog()).isSameAs((Object)watchdog);
        Truth.assertThat((Comparable)clientContext.getStreamWatchdogCheckInterval()).isEqualTo((Object)watchdogCheckInterval);
        Truth.assertThat((Map)clientContext.getHeaders()).isEqualTo((Object)ImmutableMap.of((Object)"k1", (Object)"v1"));
        Truth.assertThat((Map)clientContext.getInternalHeaders()).isEqualTo((Object)ImmutableMap.of((Object)"k2", (Object)"v2"));
        Truth.assertThat((Boolean)executor.shutdownCalled).isFalse();
        Truth.assertThat((Boolean)transportChannel.isShutdown()).isFalse();
        for (BackgroundResource backgroundResource : clientContext.getBackgroundResources()) {
            backgroundResource.shutdown();
        }
        Truth.assertThat((Boolean)executor.shutdownCalled).isEqualTo((Object)shouldAutoClose);
        Truth.assertThat((Boolean)transportChannel.isShutdown()).isEqualTo((Object)shouldAutoClose);
    }

    private static class FakeTransportProvider
    implements TransportChannelProvider {
        final ScheduledExecutorService executor;
        final FakeTransportChannel transport;
        final boolean shouldAutoClose;
        final Map<String, String> headers;

        FakeTransportProvider(FakeTransportChannel transport, ScheduledExecutorService executor, boolean shouldAutoClose, Map<String, String> headers) {
            this.transport = transport;
            this.executor = executor;
            this.shouldAutoClose = shouldAutoClose;
            this.headers = headers;
            this.transport.setHeaders(headers);
        }

        public boolean shouldAutoClose() {
            return this.shouldAutoClose;
        }

        public boolean needsExecutor() {
            return this.executor == null;
        }

        public TransportChannelProvider withExecutor(ScheduledExecutorService executor) {
            return new FakeTransportProvider(this.transport, executor, this.shouldAutoClose, this.headers);
        }

        public boolean needsHeaders() {
            return this.headers == null;
        }

        public TransportChannelProvider withHeaders(Map<String, String> headers) {
            return new FakeTransportProvider(this.transport, this.executor, this.shouldAutoClose, headers);
        }

        public boolean needsEndpoint() {
            return false;
        }

        public TransportChannelProvider withEndpoint(String endpoint) {
            return this;
        }

        public boolean acceptsPoolSize() {
            return false;
        }

        public TransportChannelProvider withPoolSize(int size) {
            throw new UnsupportedOperationException("FakeTransportProvider doesn't allow pool size customization");
        }

        public TransportChannel getTransportChannel() throws IOException {
            if (this.needsExecutor()) {
                throw new IllegalStateException("Needs Executor");
            }
            return this.transport;
        }

        public String getTransportName() {
            return "FakeTransport";
        }
    }

    private static class FakeExecutorProvider
    implements ExecutorProvider {
        ScheduledExecutorService executor;
        boolean shouldAutoClose;

        FakeExecutorProvider(ScheduledExecutorService executor, boolean shouldAutoClose) {
            this.executor = executor;
            this.shouldAutoClose = shouldAutoClose;
        }

        public boolean shouldAutoClose() {
            return this.shouldAutoClose;
        }

        public ScheduledExecutorService getExecutor() {
            return this.executor;
        }
    }

    private static class InterceptingExecutor
    extends ScheduledThreadPoolExecutor {
        boolean shutdownCalled = false;

        public InterceptingExecutor(int corePoolSize) {
            super(corePoolSize);
        }

        @Override
        public void shutdown() {
            this.shutdownCalled = true;
        }
    }
}

