/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.InternalApi;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.OpencensusTracer;
import com.google.api.gax.tracing.SpanName;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.opencensus.trace.BlankSpan;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi(value="For google-cloud-java client use only")
public final class OpencensusTracerFactory
implements ApiTracerFactory {
    @Nonnull
    private final Tracer internalTracer;
    @Nullable
    private final String clientNameOverride;

    public OpencensusTracerFactory() {
        this(null);
    }

    public OpencensusTracerFactory(@Nullable String clientNameOverride) {
        this(Tracing.getTracer(), clientNameOverride);
    }

    @InternalApi(value="Visible for testing")
    OpencensusTracerFactory(Tracer internalTracer, @Nullable String clientNameOverride) {
        this.internalTracer = (Tracer)Preconditions.checkNotNull((Object)internalTracer, (Object)"internalTracer can't be null");
        this.clientNameOverride = clientNameOverride;
    }

    @Override
    public ApiTracer newTracer(SpanName spanName) {
        if (this.clientNameOverride != null) {
            spanName = spanName.withClientName(this.clientNameOverride);
        }
        Span span = this.internalTracer.spanBuilder(spanName.toString()).setRecordEvents(true).startSpan();
        return new OpencensusTracer(this.internalTracer, span);
    }

    @Override
    public ApiTracer newRootTracer(SpanName spanName) {
        if (this.clientNameOverride != null) {
            spanName = spanName.withClientName(this.clientNameOverride);
        }
        Span span = this.internalTracer.spanBuilderWithExplicitParent(spanName.toString(), (Span)BlankSpan.INSTANCE).setRecordEvents(true).startSpan();
        return new OpencensusTracer(this.internalTracer, span);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpencensusTracerFactory that = (OpencensusTracerFactory)o;
        return Objects.equal((Object)this.internalTracer, (Object)that.internalTracer) && Objects.equal((Object)this.clientNameOverride, (Object)that.clientNameOverride);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.internalTracer, this.clientNameOverride});
    }
}

