/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedResponseObserver;
import com.google.api.gax.tracing.TracedUnaryCallable;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;

@BetaApi(value="The surface for tracing is not stable and might change in the future")
@InternalApi(value="For internal use by google-cloud-java clients only")
public final class TracedServerStreamingCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    @Nonnull
    private final ApiTracerFactory tracerFactory;
    @Nonnull
    private final SpanName spanName;
    @Nonnull
    private final ServerStreamingCallable<RequestT, ResponseT> innerCallable;
    @Nonnull
    private final TracedUnaryCallable<RequestT, ResponseT> tracedFirstCallable;
    @Nonnull
    private final TracedUnaryCallable<RequestT, List<ResponseT>> tracedAllCallable;

    public TracedServerStreamingCallable(@Nonnull ServerStreamingCallable<RequestT, ResponseT> innerCallable, @Nonnull ApiTracerFactory tracerFactory, @Nonnull SpanName spanName) {
        this.tracerFactory = (ApiTracerFactory)Preconditions.checkNotNull((Object)tracerFactory, (Object)"tracerFactory can't be null");
        this.spanName = (SpanName)Preconditions.checkNotNull((Object)spanName, (Object)"spanName can't be null");
        this.innerCallable = (ServerStreamingCallable)Preconditions.checkNotNull(innerCallable, (Object)"innerCallable can't be null");
        this.tracedFirstCallable = new TracedUnaryCallable<RequestT, ResponseT>(innerCallable.first(), tracerFactory, SpanName.of(spanName.getClientName(), spanName.getMethodName() + ".First"));
        this.tracedAllCallable = new TracedUnaryCallable<RequestT, List<List<ResponseT>>>(innerCallable.all(), tracerFactory, SpanName.of(spanName.getClientName(), spanName.getMethodName() + ".All"));
    }

    @Override
    public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
        ApiTracer tracer = this.tracerFactory.newTracer(context.getTracer(), this.spanName, ApiTracerFactory.OperationType.ServerStreaming);
        TracedResponseObserver<ResponseT> tracedObserver = new TracedResponseObserver<ResponseT>(tracer, responseObserver);
        context = context.withTracer(tracer);
        try {
            this.innerCallable.call(request, tracedObserver, context);
        }
        catch (RuntimeException e) {
            tracedObserver.onError(e);
            throw e;
        }
    }

    @Override
    public UnaryCallable<RequestT, ResponseT> first() {
        return this.tracedFirstCallable;
    }

    @Override
    public UnaryCallable<RequestT, List<ResponseT>> all() {
        return this.tracedAllCallable;
    }
}

