/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.batching.v2.Batcher;
import com.google.api.gax.batching.v2.BatcherImpl;
import com.google.api.gax.batching.v2.BatchingDescriptor;
import com.google.api.gax.batching.v2.BatchingSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeBatchableApi;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class BatcherImplTest {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Mock
    private UnaryCallable<FakeBatchableApi.LabeledIntList, List<Integer>> mockUnaryCallable;
    @Mock
    private BatchingDescriptor<Integer, Integer, FakeBatchableApi.LabeledIntList, List<Integer>> mockDescriptor;
    private Batcher<Integer, Integer> underTest;
    private final FakeBatchableApi.LabeledIntList labeledIntList = new FakeBatchableApi.LabeledIntList("Default", new Integer[0]);
    private final BatchingSettings batchingSettings = BatchingSettings.newBuilder().setRequestByteThreshold(1000L).setElementCountThreshold(1000).build();

    @After
    public void tearDown() throws InterruptedException {
        if (this.underTest != null) {
            this.underTest.close();
        }
    }

    @Test
    public void testResultsAreResolvedAfterFlush() throws Exception {
        this.underTest = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, (UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (Object)this.labeledIntList, this.batchingSettings);
        ApiFuture result = this.underTest.add((Object)4);
        Truth.assertThat((Boolean)result.isDone()).isFalse();
        this.underTest.flush();
        Truth.assertThat((Boolean)result.isDone()).isTrue();
        Truth.assertThat((Integer)((Integer)result.get())).isEqualTo((Object)16);
        ApiFuture anotherResult = this.underTest.add((Object)5);
        Truth.assertThat((Boolean)anotherResult.isDone()).isFalse();
    }

    @Test
    public void testWhenBatcherIsClose() throws Exception {
        ApiFuture result;
        try (BatcherImpl batcher = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, (UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (Object)this.labeledIntList, this.batchingSettings);){
            result = batcher.add((Object)5);
        }
        Truth.assertThat((Boolean)result.isDone()).isTrue();
        Truth.assertThat((Integer)((Integer)result.get())).isEqualTo((Object)25);
    }

    @Test
    public void testNoElementAdditionAfterClose() throws Exception {
        this.underTest = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, (UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (Object)this.labeledIntList, this.batchingSettings);
        this.underTest.close();
        Exception actualError = null;
        try {
            this.underTest.add((Object)1);
        }
        catch (Exception ex) {
            actualError = ex;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(IllegalStateException.class);
        Truth.assertThat((String)actualError.getMessage()).matches("Cannot add elements on a closed batcher");
    }

    @Test
    public void testResultsAfterRPCSucceed() throws Exception {
        this.underTest = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, this.mockUnaryCallable, (Object)this.labeledIntList, this.batchingSettings);
        Mockito.when((Object)this.mockUnaryCallable.futureCall(ArgumentMatchers.any(FakeBatchableApi.LabeledIntList.class))).thenReturn((Object)ApiFutures.immediateFuture(Arrays.asList(16, 25)));
        ApiFuture result = this.underTest.add((Object)4);
        ApiFuture anotherResult = this.underTest.add((Object)5);
        this.underTest.flush();
        Truth.assertThat((Boolean)result.isDone()).isTrue();
        Truth.assertThat((Integer)((Integer)result.get())).isEqualTo((Object)16);
        Truth.assertThat((Integer)((Integer)anotherResult.get())).isEqualTo((Object)25);
        ((UnaryCallable)Mockito.verify(this.mockUnaryCallable, (VerificationMode)Mockito.times((int)1))).futureCall(ArgumentMatchers.any(FakeBatchableApi.LabeledIntList.class));
    }

    @Test
    public void testResultFailureAfterRPCFailure() throws Exception {
        this.underTest = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, this.mockUnaryCallable, (Object)this.labeledIntList, this.batchingSettings);
        RuntimeException fakeError = new RuntimeException();
        Mockito.when((Object)this.mockUnaryCallable.futureCall(ArgumentMatchers.any(FakeBatchableApi.LabeledIntList.class))).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)fakeError));
        ApiFuture failedResult = this.underTest.add((Object)5);
        this.underTest.flush();
        Truth.assertThat((Boolean)failedResult.isDone()).isTrue();
        Exception actualError = null;
        try {
            failedResult.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            actualError = ex;
        }
        Truth.assertThat((Throwable)actualError.getCause()).isSameInstanceAs((Object)fakeError);
        ((UnaryCallable)Mockito.verify(this.mockUnaryCallable, (VerificationMode)Mockito.times((int)1))).futureCall(ArgumentMatchers.any(FakeBatchableApi.LabeledIntList.class));
    }

    @Test
    public void testExceptionInDescriptor() throws InterruptedException {
        this.underTest = new BatcherImpl(this.mockDescriptor, (UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (Object)this.labeledIntList, this.batchingSettings);
        RuntimeException fakeError = new RuntimeException("internal exception");
        Mockito.when((Object)this.mockDescriptor.newRequestBuilder(ArgumentMatchers.any(FakeBatchableApi.LabeledIntList.class))).thenReturn(FakeBatchableApi.SQUARER_BATCHING_DESC_V2.newRequestBuilder(this.labeledIntList));
        ((BatchingDescriptor)Mockito.doThrow((Throwable[])new Throwable[]{fakeError}).when(this.mockDescriptor)).splitResponse((Object)Mockito.anyList(), Mockito.anyList());
        ((BatchingDescriptor)Mockito.doThrow((Throwable[])new Throwable[]{fakeError}).when(this.mockDescriptor)).splitException((Throwable)Mockito.any(), Mockito.anyList());
        ApiFuture result = this.underTest.add((Object)2);
        this.underTest.flush();
        ExecutionException actualError = null;
        try {
            result.get();
        }
        catch (ExecutionException ex) {
            actualError = ex;
        }
        Truth.assertThat((Throwable)actualError.getCause()).isSameInstanceAs((Object)fakeError);
        ((BatchingDescriptor)Mockito.verify(this.mockDescriptor)).splitResponse((Object)Mockito.anyList(), Mockito.anyList());
    }

    @Test
    public void testExceptionInDescriptorErrorHandling() throws InterruptedException {
        this.underTest = new BatcherImpl(this.mockDescriptor, this.mockUnaryCallable, (Object)this.labeledIntList, this.batchingSettings);
        RuntimeException fakeRpcError = new RuntimeException("RPC error");
        RuntimeException fakeError = new RuntimeException("internal exception");
        Mockito.when((Object)this.mockUnaryCallable.futureCall(ArgumentMatchers.any(FakeBatchableApi.LabeledIntList.class))).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)fakeRpcError));
        Mockito.when((Object)this.mockDescriptor.newRequestBuilder(ArgumentMatchers.any(FakeBatchableApi.LabeledIntList.class))).thenReturn(FakeBatchableApi.SQUARER_BATCHING_DESC_V2.newRequestBuilder(this.labeledIntList));
        ((BatchingDescriptor)Mockito.doThrow((Throwable[])new Throwable[]{fakeError}).when(this.mockDescriptor)).splitException((Throwable)ArgumentMatchers.any(Throwable.class), Mockito.anyList());
        ApiFuture result = this.underTest.add((Object)2);
        this.underTest.flush();
        ExecutionException actualError = null;
        try {
            result.get();
        }
        catch (ExecutionException ex) {
            actualError = ex;
        }
        Truth.assertThat((Throwable)actualError.getCause()).isSameInstanceAs((Object)fakeError);
        ((BatchingDescriptor)Mockito.verify(this.mockDescriptor)).splitException((Throwable)ArgumentMatchers.any(Throwable.class), Mockito.anyList());
    }

    @Test
    public void testWhenElementCountExceeds() throws Exception {
        BatchingSettings settings = this.batchingSettings.toBuilder().setElementCountThreshold(2).build();
        this.testElementTriggers(settings);
    }

    @Test
    public void testWhenElementBytesExceeds() throws Exception {
        BatchingSettings settings = this.batchingSettings.toBuilder().setRequestByteThreshold(2L).build();
        this.testElementTriggers(settings);
    }

    @Test
    public void testWhenThresholdIsDisabled() throws Exception {
        BatchingSettings settings = BatchingSettings.newBuilder().setElementCountThreshold(0).setRequestByteThreshold(0L).build();
        this.underTest = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, (UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (Object)this.labeledIntList, settings);
        ApiFuture result = this.underTest.add((Object)2);
        Truth.assertThat((Boolean)result.isDone()).isTrue();
        Truth.assertThat((Integer)((Integer)result.get())).isEqualTo((Object)4);
    }

    private void testElementTriggers(BatchingSettings settings) throws Exception {
        this.underTest = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, (UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (Object)this.labeledIntList, settings);
        ApiFuture result = this.underTest.add((Object)4);
        Truth.assertThat((Boolean)result.isDone()).isFalse();
        ApiFuture anotherResult = this.underTest.add((Object)5);
        Truth.assertThat((Boolean)result.isDone()).isTrue();
        Truth.assertThat((Integer)((Integer)result.get())).isEqualTo((Object)16);
        Truth.assertThat((Boolean)anotherResult.isDone()).isTrue();
    }
}

