/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.rpc.AccumulatingStreamObserver;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.BidiStream;
import com.google.api.gax.rpc.BidiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakeCallableFactory;
import com.google.api.gax.rpc.testing.FakeChannel;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.api.gax.rpc.testing.FakeStreamingApi;
import com.google.api.gax.rpc.testing.FakeTransportChannel;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.junit.Test;

public class BidiStreamingCallableTest {
    private ClientContext clientContext = ClientContext.newBuilder().setDefaultCallContext((ApiCallContext)FakeCallContext.createDefault()).setTransportChannel((TransportChannel)FakeTransportChannel.create(new FakeChannel())).build();

    @Test
    public void bidiStreaming_ResponseObserver() {
        FakeStreamingApi.BidiStreamingStashCallable callIntList = new FakeStreamingApi.BidiStreamingStashCallable(Arrays.asList(0, 1, 2));
        BidiStreamingCallable callable = FakeCallableFactory.createBidiStreamingCallable(callIntList, StreamingCallSettings.newBuilder().build(), this.clientContext);
        AccumulatingStreamObserver responseObserver = new AccumulatingStreamObserver();
        ClientStream stream = callable.splitCall((ResponseObserver)responseObserver);
        stream.send((Object)3);
        stream.send((Object)4);
        stream.send((Object)5);
        stream.closeSend();
        Truth.assertThat(responseObserver.getValues()).containsExactly(new Object[]{0, 1, 2}).inOrder();
        Truth.assertThat(callIntList.getActualRequests()).containsExactly(new Object[]{3, 4, 5}).inOrder();
    }

    @Test
    public void bidiStreaming_BidiStreamObserver() throws InterruptedException {
        FakeStreamingApi.BidiStreamingStashCallable callIntList = new FakeStreamingApi.BidiStreamingStashCallable(Arrays.asList(0, 1, 2));
        BidiStreamingCallable callable = FakeCallableFactory.createBidiStreamingCallable(callIntList, StreamingCallSettings.newBuilder().build(), this.clientContext);
        AccumulatingBidiObserver observer = new AccumulatingBidiObserver(Arrays.asList(3, 4, 5));
        callable.call((BidiStreamObserver)observer);
        Truth.assertThat(observer.getResponses()).containsExactly(new Object[]{0, 1, 2}).inOrder();
        Truth.assertThat(callIntList.getActualRequests()).containsExactly(new Object[]{3, 4, 5}).inOrder();
    }

    @Test
    public void bidiStreaming_BidiStream() {
        FakeStreamingApi.BidiStreamingStashCallable callIntList = new FakeStreamingApi.BidiStreamingStashCallable(Arrays.asList(0, 1, 2));
        BidiStreamingCallable callable = FakeCallableFactory.createBidiStreamingCallable(callIntList, StreamingCallSettings.newBuilder().build(), this.clientContext);
        BidiStream stream = callIntList.call();
        stream.send((Object)3);
        stream.send((Object)4);
        stream.send((Object)5);
        stream.closeSend();
        Truth.assertThat(callIntList.getActualRequests()).containsExactly(new Object[]{3, 4, 5}).inOrder();
        Truth.assertThat((Iterable)stream).containsExactly(new Object[]{0, 1, 2}).inOrder();
    }

    private static class AccumulatingBidiObserver
    implements BidiStreamObserver<Integer, Integer> {
        private final List<Integer> received = new ArrayList<Integer>();
        private Throwable error;
        private final CountDownLatch latch = new CountDownLatch(1);
        private final Iterator<Integer> toSend;

        AccumulatingBidiObserver(Collection<Integer> toSend) {
            this.toSend = toSend.iterator();
        }

        public void onStart(StreamController controller) {
        }

        public void onResponse(Integer response) {
            this.received.add(response);
        }

        public void onComplete() {
            this.latch.countDown();
        }

        public void onError(Throwable t) {
            this.error = t;
            this.latch.countDown();
        }

        public void onReady(ClientStream<Integer> stream) {
            while (this.toSend.hasNext()) {
                if (stream.isSendReady()) {
                    stream.send((Object)this.toSend.next());
                    continue;
                }
                return;
            }
            stream.closeSend();
        }

        List<Integer> getResponses() throws InterruptedException {
            this.latch.await();
            if (this.error != null) {
                throw ApiExceptionFactory.createException((Throwable)this.error, (StatusCode)FakeStatusCode.of(StatusCode.Code.UNKNOWN), (boolean)false);
            }
            return this.received;
        }
    }
}

