/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.rpc.AccumulatingStreamObserver;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StateCheckingResponseObserver;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakeCallableFactory;
import com.google.api.gax.rpc.testing.FakeChannel;
import com.google.api.gax.rpc.testing.FakeSimpleApi;
import com.google.api.gax.rpc.testing.FakeStreamingApi;
import com.google.api.gax.rpc.testing.FakeTransportChannel;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.Arrays;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class ServerStreamingCallableTest {
    private ClientContext clientContext;

    @Before
    public void setUp() {
        this.clientContext = ClientContext.newBuilder().setDefaultCallContext((ApiCallContext)FakeCallContext.createDefault()).setTransportChannel((TransportChannel)FakeTransportChannel.create(new FakeChannel())).build();
    }

    @Test
    public void serverStreaming() {
        FakeStreamingApi.ServerStreamingStashCallable callIntList = new FakeStreamingApi.ServerStreamingStashCallable(Arrays.asList(0, 1, 2));
        ServerStreamingCallable callable = FakeCallableFactory.createServerStreamingCallable(callIntList, StreamingCallSettings.newBuilder().build(), this.clientContext);
        AccumulatingStreamObserver responseObserver = new AccumulatingStreamObserver();
        callable.call((Object)0, (ResponseObserver)responseObserver);
        Truth.assertThat((Iterable)ImmutableList.copyOf(responseObserver.getValues())).containsExactly(new Object[]{0, 1, 2}).inOrder();
        Truth.assertThat((Integer)((Integer)callIntList.getActualRequest())).isEqualTo((Object)0);
    }

    @Test
    public void testServerStreamingCall() {
        FakeCallContext defaultCallContext = FakeCallContext.createDefault();
        FakeStreamingApi.ServerStreamingStashCallable stashCallable = new FakeStreamingApi.ServerStreamingStashCallable();
        ServerStreamingCallable callable = stashCallable.withDefaultCallContext(defaultCallContext);
        StateCheckingResponseObserver observer = (StateCheckingResponseObserver)Mockito.mock(StateCheckingResponseObserver.class);
        Integer request = 1;
        callable.call((Object)request, (ResponseObserver)observer);
        Truth.assertThat(stashCallable.getActualObserver()).isSameAs((Object)observer);
        Truth.assertThat((Integer)((Integer)stashCallable.getActualRequest())).isSameAs((Object)request);
        Truth.assertThat((Object)stashCallable.getContext()).isSameAs((Object)defaultCallContext);
    }

    @Test
    public void testServerStreamingCallWithContext() {
        FakeChannel channel = new FakeChannel();
        Credentials credentials = (Credentials)Mockito.mock(Credentials.class);
        FakeCallContext context = FakeCallContext.createDefault().withChannel(channel).withCredentials(credentials);
        FakeStreamingApi.ServerStreamingStashCallable stashCallable = new FakeStreamingApi.ServerStreamingStashCallable();
        ServerStreamingCallable callable = stashCallable.withDefaultCallContext(FakeCallContext.createDefault());
        ResponseObserver observer = (ResponseObserver)Mockito.mock(StateCheckingResponseObserver.class);
        Integer request = 1;
        callable.call((Object)request, observer, (ApiCallContext)context);
        Truth.assertThat(stashCallable.getActualObserver()).isSameAs((Object)observer);
        Truth.assertThat((Integer)((Integer)stashCallable.getActualRequest())).isSameAs((Object)request);
        FakeCallContext actualContext = (FakeCallContext)stashCallable.getContext();
        Truth.assertThat((Object)actualContext.getChannel()).isSameAs((Object)channel);
        Truth.assertThat((Object)actualContext.getCredentials()).isSameAs((Object)credentials);
    }

    @Test
    public void blockingServerStreaming() {
        FakeStreamingApi.ServerStreamingStashCallable callIntList = new FakeStreamingApi.ServerStreamingStashCallable(Arrays.asList(0, 1, 2));
        ServerStreamingCallable callable = FakeCallableFactory.createServerStreamingCallable(callIntList, StreamingCallSettings.newBuilder().build(), this.clientContext);
        Truth.assertThat((Iterable)ImmutableList.copyOf((Iterable)callable.call((Object)0))).containsExactly(new Object[]{0, 1, 2}).inOrder();
        Truth.assertThat((Integer)((Integer)callIntList.getActualRequest())).isEqualTo((Object)0);
    }

    @Test
    public void testIteratedServerStreamingCall() {
        FakeCallContext defaultCallContext = FakeCallContext.createDefault();
        FakeStreamingApi.ServerStreamingStashCallable stashCallable = new FakeStreamingApi.ServerStreamingStashCallable();
        ServerStreamingCallable callable = stashCallable.withDefaultCallContext(defaultCallContext);
        Integer request = 1;
        callable.call((Object)request);
        Truth.assertThat((Integer)((Integer)stashCallable.getActualRequest())).isSameAs((Object)request);
        Truth.assertThat((Object)stashCallable.getContext()).isSameAs((Object)defaultCallContext);
    }

    @Test
    public void testIteratedServerStreamingCallWithContext() {
        FakeChannel channel = new FakeChannel();
        Credentials credentials = (Credentials)Mockito.mock(Credentials.class);
        FakeCallContext context = FakeCallContext.createDefault().withChannel(channel).withCredentials(credentials);
        FakeStreamingApi.ServerStreamingStashCallable stashCallable = new FakeStreamingApi.ServerStreamingStashCallable();
        ServerStreamingCallable callable = stashCallable.withDefaultCallContext(FakeCallContext.createDefault());
        Integer request = 1;
        callable.call((Object)request, (ApiCallContext)context);
        Truth.assertThat((Integer)((Integer)stashCallable.getActualRequest())).isSameAs((Object)request);
        FakeCallContext actualContext = (FakeCallContext)stashCallable.getContext();
        Truth.assertThat((Object)actualContext.getChannel()).isSameAs((Object)channel);
        Truth.assertThat((Object)actualContext.getCredentials()).isSameAs((Object)credentials);
    }

    @Test
    public void testFirstElementCall() {
        FakeStreamingApi.ServerStreamingStashCallable callIntList = new FakeStreamingApi.ServerStreamingStashCallable(Arrays.asList(0, 1, 2));
        ServerStreamingCallable streamingCallable = FakeCallableFactory.createServerStreamingCallable(callIntList, StreamingCallSettings.newBuilder().build(), this.clientContext);
        UnaryCallable callable = streamingCallable.first();
        Truth.assertThat((Integer)((Integer)callable.call((Object)0))).isEqualTo((Object)0);
        Truth.assertThat((Integer)((Integer)callIntList.getActualRequest())).isEqualTo((Object)0);
    }

    @Test
    public void testFirstElementCallWithDefaultContext() {
        FakeCallContext defaultCallContext = FakeCallContext.createDefault();
        final FakeSimpleApi.StashCallable stashFirstCallable = new FakeSimpleApi.StashCallable(11);
        FakeStreamingApi.ServerStreamingStashCallable<Integer, Integer> stashCallable = new FakeStreamingApi.ServerStreamingStashCallable<Integer, Integer>(){

            public UnaryCallable<Integer, Integer> first() {
                return stashFirstCallable;
            }
        };
        UnaryCallable firstCallable = stashCallable.withDefaultCallContext(defaultCallContext).first();
        Integer request = 1;
        firstCallable.call((Object)request);
        Truth.assertThat((Integer)((Integer)stashFirstCallable.getRequest())).isSameAs((Object)request);
        Truth.assertThat((Object)stashFirstCallable.getContext()).isSameAs((Object)defaultCallContext);
    }

    @Test
    public void testFirstElementCallWithContext() {
        FakeChannel channel = new FakeChannel();
        Credentials credentials = (Credentials)Mockito.mock(Credentials.class);
        FakeCallContext context = FakeCallContext.createDefault().withChannel(channel).withCredentials(credentials);
        FakeStreamingApi.ServerStreamingStashCallable stashCallable = new FakeStreamingApi.ServerStreamingStashCallable();
        UnaryCallable firstCallable = stashCallable.first().withDefaultCallContext((ApiCallContext)FakeCallContext.createDefault());
        Integer request = 1;
        firstCallable.call((Object)request, (ApiCallContext)context);
        Truth.assertThat((Integer)((Integer)stashCallable.getActualRequest())).isSameAs((Object)request);
        FakeCallContext actualContext = (FakeCallContext)stashCallable.getContext();
        Truth.assertThat((Object)actualContext.getChannel()).isSameAs((Object)channel);
        Truth.assertThat((Object)actualContext.getCredentials()).isSameAs((Object)credentials);
    }

    @Test
    public void testAllElementCall() {
        FakeStreamingApi.ServerStreamingStashCallable callIntList = new FakeStreamingApi.ServerStreamingStashCallable(Arrays.asList(0, 1, 2));
        ServerStreamingCallable streamingCallable = FakeCallableFactory.createServerStreamingCallable(callIntList, StreamingCallSettings.newBuilder().build(), this.clientContext);
        UnaryCallable callable = streamingCallable.all();
        Truth.assertThat((Iterable)((Iterable)callable.call((Object)0))).containsExactly(new Object[]{0, 1, 2}).inOrder();
        Truth.assertThat((Integer)((Integer)callIntList.getActualRequest())).isEqualTo((Object)0);
    }

    @Test
    public void testAllElementCallWithDefaultContext() {
        FakeCallContext defaultCallContext = FakeCallContext.createDefault();
        FakeStreamingApi.ServerStreamingStashCallable stashCallable = new FakeStreamingApi.ServerStreamingStashCallable();
        UnaryCallable firstCallable = stashCallable.all().withDefaultCallContext((ApiCallContext)defaultCallContext);
        Integer request = 1;
        firstCallable.call((Object)request);
        Truth.assertThat((Integer)((Integer)stashCallable.getActualRequest())).isSameAs((Object)request);
        Truth.assertThat((Object)stashCallable.getContext()).isSameAs((Object)defaultCallContext);
    }

    @Test
    public void testAllElementCallWithContext() {
        FakeChannel channel = new FakeChannel();
        Credentials credentials = (Credentials)Mockito.mock(Credentials.class);
        FakeCallContext context = FakeCallContext.createDefault().withChannel(channel).withCredentials(credentials);
        FakeStreamingApi.ServerStreamingStashCallable stashCallable = new FakeStreamingApi.ServerStreamingStashCallable();
        UnaryCallable firstCallable = stashCallable.all().withDefaultCallContext((ApiCallContext)FakeCallContext.createDefault());
        Integer request = 1;
        firstCallable.call((Object)request, (ApiCallContext)context);
        Truth.assertThat((Integer)((Integer)stashCallable.getActualRequest())).isSameAs((Object)request);
        FakeCallContext actualContext = (FakeCallContext)stashCallable.getContext();
        Truth.assertThat((Object)actualContext.getChannel()).isSameAs((Object)channel);
        Truth.assertThat((Object)actualContext.getCredentials()).isSameAs((Object)credentials);
    }
}

