/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.testing;

import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.internal.Headers;
import com.google.api.gax.rpc.testing.FakeChannel;
import com.google.api.gax.rpc.testing.FakeTransportChannel;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.NoopApiTracer;
import com.google.auth.Credentials;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

@InternalApi(value="for testing")
public class FakeCallContext
implements ApiCallContext {
    private final Credentials credentials;
    private final FakeChannel channel;
    private final Duration timeout;
    private final Duration streamWaitTimeout;
    private final Duration streamIdleTimeout;
    private final ImmutableMap<String, List<String>> extraHeaders;
    private final ApiTracer tracer;

    private FakeCallContext(Credentials credentials, FakeChannel channel, Duration timeout, Duration streamWaitTimeout, Duration streamIdleTimeout, ImmutableMap<String, List<String>> extraHeaders, ApiTracer tracer) {
        this.credentials = credentials;
        this.channel = channel;
        this.timeout = timeout;
        this.streamWaitTimeout = streamWaitTimeout;
        this.streamIdleTimeout = streamIdleTimeout;
        this.extraHeaders = extraHeaders;
        this.tracer = tracer;
    }

    public static FakeCallContext createDefault() {
        return new FakeCallContext(null, null, null, null, null, (ImmutableMap<String, List<String>>)ImmutableMap.of(), null);
    }

    public FakeCallContext nullToSelf(ApiCallContext inputContext) {
        FakeCallContext fakeCallContext;
        if (inputContext == null) {
            fakeCallContext = this;
        } else {
            if (!(inputContext instanceof FakeCallContext)) {
                throw new IllegalArgumentException("context must be an instance of FakeCallContext, but found " + inputContext.getClass().getName());
            }
            fakeCallContext = (FakeCallContext)inputContext;
        }
        return fakeCallContext;
    }

    public ApiCallContext merge(ApiCallContext inputCallContext) {
        ApiTracer newTracer;
        Duration newStreamIdleTimeout;
        Duration newStreamWaitTimeout;
        Duration newTimeout;
        Credentials newCallCredentials;
        if (inputCallContext == null) {
            return this;
        }
        if (!(inputCallContext instanceof FakeCallContext)) {
            throw new IllegalArgumentException("context must be an instance of FakeCallContext, but found " + inputCallContext.getClass().getName());
        }
        FakeCallContext fakeCallContext = (FakeCallContext)inputCallContext;
        FakeChannel newChannel = fakeCallContext.channel;
        if (newChannel == null) {
            newChannel = this.channel;
        }
        if ((newCallCredentials = fakeCallContext.credentials) == null) {
            newCallCredentials = this.credentials;
        }
        if ((newTimeout = fakeCallContext.timeout) == null) {
            newTimeout = this.timeout;
        }
        if ((newStreamWaitTimeout = fakeCallContext.streamWaitTimeout) == null) {
            newStreamWaitTimeout = this.streamWaitTimeout;
        }
        if ((newStreamIdleTimeout = fakeCallContext.streamIdleTimeout) == null) {
            newStreamIdleTimeout = this.streamIdleTimeout;
        }
        if ((newTracer = fakeCallContext.tracer) == null) {
            newTracer = this.tracer;
        }
        ImmutableMap newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, fakeCallContext.extraHeaders);
        return new FakeCallContext(newCallCredentials, newChannel, newTimeout, newStreamWaitTimeout, newStreamIdleTimeout, (ImmutableMap<String, List<String>>)newExtraHeaders, newTracer);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public FakeChannel getChannel() {
        return this.channel;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    @Nullable
    public Duration getStreamWaitTimeout() {
        return this.streamWaitTimeout;
    }

    @Nullable
    public Duration getStreamIdleTimeout() {
        return this.streamIdleTimeout;
    }

    public FakeCallContext withCredentials(Credentials credentials) {
        return new FakeCallContext(credentials, this.channel, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.tracer);
    }

    public FakeCallContext withTransportChannel(TransportChannel inputChannel) {
        Preconditions.checkNotNull((Object)inputChannel);
        if (!(inputChannel instanceof FakeTransportChannel)) {
            throw new IllegalArgumentException("Expected FakeTransportChannel, got " + inputChannel.getClass().getName());
        }
        FakeTransportChannel transportChannel = (FakeTransportChannel)inputChannel;
        return this.withChannel(transportChannel.getChannel());
    }

    public FakeCallContext withChannel(FakeChannel channel) {
        return new FakeCallContext(this.credentials, channel, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.tracer);
    }

    public FakeCallContext withTimeout(Duration timeout) {
        if (timeout != null && (timeout.isZero() || timeout.isNegative())) {
            timeout = null;
        }
        if (timeout != null && this.timeout != null && this.timeout.compareTo(timeout) <= 0) {
            return this;
        }
        return new FakeCallContext(this.credentials, this.channel, timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.tracer);
    }

    public ApiCallContext withStreamWaitTimeout(@Nullable Duration streamWaitTimeout) {
        return new FakeCallContext(this.credentials, this.channel, this.timeout, streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.tracer);
    }

    public ApiCallContext withStreamIdleTimeout(@Nullable Duration streamIdleTimeout) {
        Preconditions.checkNotNull((Object)streamIdleTimeout);
        return new FakeCallContext(this.credentials, this.channel, this.timeout, this.streamWaitTimeout, streamIdleTimeout, this.extraHeaders, this.tracer);
    }

    public ApiCallContext withExtraHeaders(Map<String, List<String>> extraHeaders) {
        Preconditions.checkNotNull(extraHeaders);
        ImmutableMap newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, extraHeaders);
        return new FakeCallContext(this.credentials, this.channel, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, (ImmutableMap<String, List<String>>)newExtraHeaders, this.tracer);
    }

    public Map<String, List<String>> getExtraHeaders() {
        return this.extraHeaders;
    }

    @Nonnull
    public ApiTracer getTracer() {
        if (this.tracer == null) {
            return NoopApiTracer.getInstance();
        }
        return this.tracer;
    }

    public ApiCallContext withTracer(@Nonnull ApiTracer tracer) {
        Preconditions.checkNotNull((Object)tracer);
        return new FakeCallContext(this.credentials, this.channel, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, tracer);
    }

    public static FakeCallContext create(ClientContext clientContext) {
        return FakeCallContext.createDefault().withTransportChannel(clientContext.getTransportChannel()).withCredentials(clientContext.getCredentials());
    }
}

