/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.CancelledException;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.NoopApiTracer;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedClientStreamingCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class TracedClientStreamingCallableTest {
    private static final SpanName SPAN_NAME = SpanName.of((String)"fake-client", (String)"fake-method");
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    private ApiTracerFactory tracerFactory;
    private ApiTracer parentTracer = NoopApiTracer.getInstance();
    @Mock
    private ApiTracer tracer;
    private FakeClientCallable innerCallable;
    private TracedClientStreamingCallable<String, String> tracedCallable;
    private FakeStreamObserver outerResponseObsever;
    private FakeCallContext callContext;

    @Before
    public void setUp() {
        Mockito.when((Object)this.tracerFactory.newTracer(this.parentTracer, SPAN_NAME, ApiTracerFactory.OperationType.ClientStreaming)).thenReturn((Object)this.tracer);
        this.innerCallable = new FakeClientCallable();
        this.tracedCallable = new TracedClientStreamingCallable((ClientStreamingCallable)this.innerCallable, this.tracerFactory, SPAN_NAME);
        this.outerResponseObsever = new FakeStreamObserver();
        this.callContext = FakeCallContext.createDefault();
    }

    @Test
    public void testTracerCreated() {
        this.tracedCallable.clientStreamingCall((ApiStreamObserver)this.outerResponseObsever, (ApiCallContext)this.callContext);
        ((ApiTracerFactory)Mockito.verify((Object)this.tracerFactory, (VerificationMode)Mockito.times((int)1))).newTracer(this.parentTracer, SPAN_NAME, ApiTracerFactory.OperationType.ClientStreaming);
    }

    @Test
    public void testCallContextPropagated() {
        ImmutableMap extraHeaders = ImmutableMap.of((Object)"header1", (Object)ImmutableList.of((Object)"value1"));
        ApiCallContext newCallContext = this.callContext.withExtraHeaders((Map<String, List<String>>)extraHeaders);
        this.tracedCallable.clientStreamingCall((ApiStreamObserver)this.outerResponseObsever, newCallContext);
        Truth.assertThat((Map)this.innerCallable.callContext.getExtraHeaders()).isEqualTo((Object)extraHeaders);
    }

    @Test
    public void testOperationCancelled() {
        ApiStreamObserver clientStream = this.tracedCallable.clientStreamingCall((ApiStreamObserver)this.outerResponseObsever, (ApiCallContext)this.callContext);
        clientStream.onError((Throwable)new CancellationException("explicitly cancelled"));
        this.innerCallable.responseObserver.onError((Throwable)new CancelledException("fake exception that would be generated by a client cancelling the rpc", null, (StatusCode)FakeStatusCode.of(StatusCode.Code.CANCELLED), false));
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationCancelled();
    }

    @Test
    public void testOperationFinished() {
        this.tracedCallable.clientStreamingCall((ApiStreamObserver)this.outerResponseObsever, (ApiCallContext)this.callContext);
        this.innerCallable.responseObserver.onNext((Object)"ignored");
        this.innerCallable.responseObserver.onCompleted();
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationSucceeded();
    }

    @Test
    public void testOperationFailed() {
        RuntimeException expectedError = new RuntimeException("fake error");
        this.tracedCallable.clientStreamingCall((ApiStreamObserver)this.outerResponseObsever, (ApiCallContext)this.callContext);
        this.innerCallable.responseObserver.onError((Throwable)expectedError);
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)expectedError);
    }

    @Test
    public void testSyncError() {
        RuntimeException expectedError = new RuntimeException("fake error");
        this.innerCallable.syncError = expectedError;
        try {
            this.tracedCallable.clientStreamingCall((ApiStreamObserver)this.outerResponseObsever, (ApiCallContext)this.callContext);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)expectedError);
    }

    @Test
    public void testRequestNotify() {
        ApiStreamObserver requestStream = this.tracedCallable.clientStreamingCall((ApiStreamObserver)this.outerResponseObsever, (ApiCallContext)this.callContext);
        requestStream.onNext((Object)"request1");
        requestStream.onNext((Object)"request2");
        this.innerCallable.responseObserver.onNext((Object)"response");
        this.innerCallable.responseObserver.onCompleted();
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)2))).requestSent();
        Truth.assertThat((Boolean)this.outerResponseObsever.completed).isTrue();
        Truth.assertThat((Iterable)this.innerCallable.requestObserver.messages).containsExactly(new Object[]{"request1", "request2"});
    }

    private static class FakeStreamObserver
    implements ApiStreamObserver<String> {
        private List<String> messages = Lists.newArrayList();
        private Throwable error;
        private boolean completed;

        private FakeStreamObserver() {
        }

        public void onNext(String value) {
            this.messages.add(value);
        }

        public void onError(Throwable t) {
            this.error = t;
            this.completed = true;
        }

        public void onCompleted() {
            this.completed = true;
        }
    }

    private static class FakeClientCallable
    extends ClientStreamingCallable<String, String> {
        private RuntimeException syncError;
        private ApiStreamObserver<String> responseObserver;
        private ApiCallContext callContext;
        private FakeStreamObserver requestObserver;

        private FakeClientCallable() {
        }

        public ApiStreamObserver<String> clientStreamingCall(ApiStreamObserver<String> responseObserver, ApiCallContext context) {
            if (this.syncError != null) {
                throw this.syncError;
            }
            this.responseObserver = responseObserver;
            this.callContext = context;
            this.requestObserver = new FakeStreamObserver();
            return this.requestObserver;
        }
    }
}

