/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import com.google.api.core.ApiFutures;
import com.google.api.gax.batching.AccumulatingBatchReceiver;
import com.google.api.gax.batching.BatchMerger;
import com.google.api.gax.batching.BatchingFlowController;
import com.google.api.gax.batching.BatchingThresholds;
import com.google.api.gax.batching.ElementCounter;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.batching.ThresholdBatchReceiver;
import com.google.api.gax.batching.ThresholdBatcher;
import com.google.api.gax.batching.TrackedFlowController;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.threeten.bp.Duration;

public class ThresholdBatcherTest {
    private static final ScheduledExecutorService EXECUTOR = new ScheduledThreadPoolExecutor(1);
    private static TrackedFlowController trackedFlowController;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    private static FlowController getDisabledFlowController() {
        return new FlowController(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Ignore).build());
    }

    private static <T> BatchingFlowController<T> getDisabledBatchingFlowController() {
        return new BatchingFlowController(ThresholdBatcherTest.getDisabledFlowController(), new ElementCounter<T>(){

            public long count(T t) {
                return 1L;
            }
        }, new ElementCounter<T>(){

            public long count(T t) {
                return 1L;
            }
        });
    }

    private static BatchingFlowController<SimpleBatch> getTrackedIntegerBatchingFlowController(Long elementCount, Long byteCount, FlowController.LimitExceededBehavior limitExceededBehaviour) {
        trackedFlowController = new TrackedFlowController(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(elementCount).setMaxOutstandingRequestBytes(byteCount).setLimitExceededBehavior(limitExceededBehaviour).build());
        return new BatchingFlowController((FlowController)trackedFlowController, (ElementCounter)new ElementCounter<SimpleBatch>(){

            public long count(SimpleBatch t) {
                return t.getIntegers().size();
            }
        }, (ElementCounter)new ElementCounter<SimpleBatch>(){

            public long count(SimpleBatch t) {
                long counter = 0L;
                for (Integer i : t.integers) {
                    counter += (long)i.intValue();
                }
                return counter;
            }
        });
    }

    private static ThresholdBatcher.Builder<SimpleBatch> createSimpleBatcherBuidler(AccumulatingBatchReceiver<SimpleBatch> receiver) {
        return ThresholdBatcher.newBuilder().setThresholds((Collection)BatchingThresholds.create((long)100L)).setExecutor(EXECUTOR).setMaxDelay(Duration.ofMillis((long)10000L)).setReceiver(receiver).setFlowController(ThresholdBatcherTest.getDisabledBatchingFlowController()).setBatchMerger((BatchMerger)new SimpleBatchMerger());
    }

    @Test
    public void testAdd() throws Exception {
        AccumulatingBatchReceiver receiver = new AccumulatingBatchReceiver(ApiFutures.immediateFuture(null));
        ThresholdBatcher batcher = ThresholdBatcherTest.createSimpleBatcherBuidler((AccumulatingBatchReceiver<SimpleBatch>)receiver).build();
        batcher.add((Object)SimpleBatch.fromInteger(14));
        Truth.assertThat((Boolean)batcher.isEmpty()).isFalse();
        Truth.assertThat((Iterable)receiver.getBatches()).hasSize(0);
        batcher.pushCurrentBatch().get();
        Truth.assertThat((Boolean)batcher.isEmpty()).isTrue();
        Truth.assertThat((Iterable)receiver.getBatches()).hasSize(1);
        Truth.assertThat((Iterable)((SimpleBatch)receiver.getBatches().get(0)).getIntegers()).isEqualTo(Arrays.asList(14));
    }

    @Test
    public void testBatching() throws Exception {
        AccumulatingBatchReceiver receiver = new AccumulatingBatchReceiver(ApiFutures.immediateFuture(null));
        ThresholdBatcher batcher = ThresholdBatcherTest.createSimpleBatcherBuidler((AccumulatingBatchReceiver<SimpleBatch>)receiver).setThresholds((Collection)BatchingThresholds.create((long)2L)).build();
        batcher.add((Object)SimpleBatch.fromInteger(3));
        batcher.add((Object)SimpleBatch.fromInteger(5));
        Thread.sleep(100L);
        Truth.assertThat((Iterable)receiver.getBatches()).hasSize(1);
        batcher.add((Object)SimpleBatch.fromInteger(7));
        batcher.add((Object)SimpleBatch.fromInteger(9));
        Thread.sleep(100L);
        Truth.assertThat((Iterable)receiver.getBatches()).hasSize(2);
        batcher.add((Object)SimpleBatch.fromInteger(11));
        batcher.pushCurrentBatch().get();
        List<List> expected = Arrays.asList(Arrays.asList(3, 5), Arrays.asList(7, 9), Arrays.asList(11));
        ArrayList<List> actual = new ArrayList<List>();
        for (SimpleBatch batch : receiver.getBatches()) {
            actual.add(batch.getIntegers());
        }
        Truth.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void testBatchingWithDelay() throws Exception {
        AccumulatingBatchReceiver receiver = new AccumulatingBatchReceiver(ApiFutures.immediateFuture(null));
        ThresholdBatcher batcher = ThresholdBatcherTest.createSimpleBatcherBuidler((AccumulatingBatchReceiver<SimpleBatch>)receiver).setMaxDelay(Duration.ofMillis((long)100L)).build();
        batcher.add((Object)SimpleBatch.fromInteger(3));
        batcher.add((Object)SimpleBatch.fromInteger(5));
        Thread.sleep(500L);
        Truth.assertThat((Iterable)receiver.getBatches()).hasSize(1);
        batcher.add((Object)SimpleBatch.fromInteger(11));
        batcher.pushCurrentBatch().get();
        List<List> expected = Arrays.asList(Arrays.asList(3, 5), Arrays.asList(11));
        ArrayList<List> actual = new ArrayList<List>();
        for (SimpleBatch batch : receiver.getBatches()) {
            actual.add(batch.getIntegers());
        }
        Truth.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void testExceptionWithNullFlowController() {
        this.thrown.expect(NullPointerException.class);
        ThresholdBatcher.newBuilder().setThresholds((Collection)BatchingThresholds.create((long)100L)).setExecutor(EXECUTOR).setMaxDelay(Duration.ofMillis((long)10000L)).setReceiver((ThresholdBatchReceiver)new AccumulatingBatchReceiver(ApiFutures.immediateFuture(null))).setBatchMerger((BatchMerger)new SimpleBatchMerger()).build();
    }

    @Test
    public void testBatchingWithFlowControl() throws Exception {
        AccumulatingBatchReceiver receiver = new AccumulatingBatchReceiver(ApiFutures.immediateFuture(null));
        ThresholdBatcher batcher = ThresholdBatcherTest.createSimpleBatcherBuidler((AccumulatingBatchReceiver<SimpleBatch>)receiver).setThresholds((Collection)BatchingThresholds.create((long)2L)).setFlowController(ThresholdBatcherTest.getTrackedIntegerBatchingFlowController(2L, null, FlowController.LimitExceededBehavior.Block)).build();
        Truth.assertThat((Long)trackedFlowController.getElementsReserved()).isEqualTo((Object)0);
        Truth.assertThat((Long)trackedFlowController.getElementsReleased()).isEqualTo((Object)0);
        Truth.assertThat((Long)trackedFlowController.getBytesReserved()).isEqualTo((Object)0);
        Truth.assertThat((Long)trackedFlowController.getBytesReleased()).isEqualTo((Object)0);
        batcher.add((Object)SimpleBatch.fromInteger(3));
        batcher.add((Object)SimpleBatch.fromInteger(5));
        batcher.add((Object)SimpleBatch.fromInteger(7));
        Truth.assertThat((Iterable)receiver.getBatches()).hasSize(1);
        batcher.add((Object)SimpleBatch.fromInteger(9));
        batcher.add((Object)SimpleBatch.fromInteger(11));
        Truth.assertThat((Iterable)receiver.getBatches()).hasSize(2);
        batcher.pushCurrentBatch().get();
        List<List> expected = Arrays.asList(Arrays.asList(3, 5), Arrays.asList(7, 9), Arrays.asList(11));
        ArrayList<List> actual = new ArrayList<List>();
        for (SimpleBatch batch : receiver.getBatches()) {
            actual.add(batch.getIntegers());
        }
        Truth.assertThat(actual).isEqualTo(expected);
        Truth.assertThat((Long)trackedFlowController.getElementsReserved()).isEqualTo((Object)trackedFlowController.getElementsReleased());
        Truth.assertThat((Long)trackedFlowController.getBytesReserved()).isEqualTo((Object)trackedFlowController.getBytesReleased());
    }

    @Test
    public void testBatchingFlowControlExceptionRecovery() throws Exception {
        AccumulatingBatchReceiver receiver = new AccumulatingBatchReceiver(ApiFutures.immediateFuture(null));
        ThresholdBatcher batcher = ThresholdBatcherTest.createSimpleBatcherBuidler((AccumulatingBatchReceiver<SimpleBatch>)receiver).setThresholds((Collection)BatchingThresholds.create((long)4L)).setFlowController(ThresholdBatcherTest.getTrackedIntegerBatchingFlowController(3L, null, FlowController.LimitExceededBehavior.ThrowException)).build();
        Truth.assertThat((Long)trackedFlowController.getElementsReserved()).isEqualTo((Object)0);
        Truth.assertThat((Long)trackedFlowController.getElementsReleased()).isEqualTo((Object)0);
        Truth.assertThat((Long)trackedFlowController.getBytesReserved()).isEqualTo((Object)0);
        Truth.assertThat((Long)trackedFlowController.getBytesReleased()).isEqualTo((Object)0);
        batcher.add((Object)SimpleBatch.fromInteger(3));
        batcher.add((Object)SimpleBatch.fromInteger(5));
        batcher.add((Object)SimpleBatch.fromInteger(7));
        try {
            batcher.add((Object)SimpleBatch.fromInteger(9));
            Assert.fail((String)"expected exception");
        }
        catch (FlowController.FlowControlException flowControlException) {
            // empty catch block
        }
        batcher.pushCurrentBatch().get();
        Truth.assertThat((Iterable)receiver.getBatches()).hasSize(1);
        batcher.add((Object)SimpleBatch.fromInteger(11));
        batcher.add((Object)SimpleBatch.fromInteger(13));
        batcher.pushCurrentBatch().get();
        List<List> expected = Arrays.asList(Arrays.asList(3, 5, 7), Arrays.asList(11, 13));
        ArrayList<List> actual = new ArrayList<List>();
        for (SimpleBatch batch : receiver.getBatches()) {
            actual.add(batch.getIntegers());
        }
        Truth.assertThat(actual).isEqualTo(expected);
        Truth.assertThat((Long)trackedFlowController.getElementsReserved()).isEqualTo((Object)trackedFlowController.getElementsReleased());
        Truth.assertThat((Long)trackedFlowController.getBytesReserved()).isEqualTo((Object)trackedFlowController.getBytesReleased());
    }

    @Test
    public void testBatchingFailedRPC() throws Exception {
        IllegalStateException ex = new IllegalStateException("does nothing, unsuccessfully");
        AccumulatingBatchReceiver receiver = new AccumulatingBatchReceiver(ApiFutures.immediateFailedFuture((Throwable)ex));
        ThresholdBatcher batcher = ThresholdBatcherTest.createSimpleBatcherBuidler((AccumulatingBatchReceiver<SimpleBatch>)receiver).setThresholds((Collection)BatchingThresholds.create((long)4L)).setFlowController(ThresholdBatcherTest.getTrackedIntegerBatchingFlowController(3L, null, FlowController.LimitExceededBehavior.ThrowException)).build();
        Truth.assertThat((Long)trackedFlowController.getElementsReserved()).isEqualTo((Object)0);
        Truth.assertThat((Long)trackedFlowController.getElementsReleased()).isEqualTo((Object)0);
        Truth.assertThat((Long)trackedFlowController.getBytesReserved()).isEqualTo((Object)0);
        Truth.assertThat((Long)trackedFlowController.getBytesReleased()).isEqualTo((Object)0);
        batcher.add((Object)SimpleBatch.fromInteger(3));
        try {
            batcher.pushCurrentBatch().get();
            Assert.fail((String)"expected exception");
        }
        catch (Exception e) {
            Truth.assertThat((Throwable)e).isInstanceOf(ExecutionException.class);
            Truth.assertThat((Throwable)e).hasCauseThat().isSameInstanceAs((Object)ex);
        }
        Truth.assertThat((Iterable)receiver.getBatches()).hasSize(1);
        List<List> expected = Arrays.asList(Arrays.asList(3));
        ArrayList<List> actual = new ArrayList<List>();
        for (SimpleBatch batch : receiver.getBatches()) {
            actual.add(batch.getIntegers());
        }
        Truth.assertThat(actual).isEqualTo(expected);
        Truth.assertThat((Long)trackedFlowController.getElementsReserved()).isEqualTo((Object)trackedFlowController.getElementsReleased());
        Truth.assertThat((Long)trackedFlowController.getBytesReserved()).isEqualTo((Object)trackedFlowController.getBytesReleased());
    }

    private static class SimpleBatchMerger
    implements BatchMerger<SimpleBatch> {
        private SimpleBatchMerger() {
        }

        public void merge(SimpleBatch batch, SimpleBatch newBatch) {
            batch.merge(newBatch);
        }
    }

    private static class SimpleBatch {
        private final List<Integer> integers = new ArrayList<Integer>();

        private SimpleBatch() {
        }

        private static SimpleBatch fromInteger(Integer integer) {
            SimpleBatch batch = new SimpleBatch();
            batch.integers.add(integer);
            return batch;
        }

        public void merge(SimpleBatch t) {
            this.integers.addAll(t.integers);
        }

        private List<Integer> getIntegers() {
            return this.integers;
        }
    }
}

