/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.batching.PartitionKey;
import com.google.api.gax.batching.RequestBuilder;
import com.google.api.gax.rpc.Batch;
import com.google.api.gax.rpc.BatchExecutor;
import com.google.api.gax.rpc.BatchedRequestIssuer;
import com.google.api.gax.rpc.BatchingDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BatchExecutorTest {
    BatchingDescriptor<List<Integer>, Integer> integerDescriptor = new BatchingDescriptor<List<Integer>, Integer>(){

        public PartitionKey getBatchPartitionKey(List<Integer> request) {
            return new PartitionKey(new Object[]{request.get(0) % 2});
        }

        public RequestBuilder<List<Integer>> getRequestBuilder() {
            return new RequestBuilder<List<Integer>>(){
                List<Integer> list = new ArrayList<Integer>();

                public void appendRequest(List<Integer> request) {
                    this.list.addAll(request);
                }

                public List<Integer> build() {
                    return this.list;
                }
            };
        }

        public void splitResponse(Integer batchResponse, Collection<? extends BatchedRequestIssuer<Integer>> batch) {
        }

        public void splitException(Throwable throwable, Collection<? extends BatchedRequestIssuer<Integer>> batch) {
        }

        public long countElements(List<Integer> request) {
            return request.size();
        }

        public long countBytes(List<Integer> request) {
            return request.size();
        }
    };

    @Test
    public void testValidate() {
        BatchExecutor executor = new BatchExecutor(this.integerDescriptor, new PartitionKey(new Object[]{0}));
        ArrayList<Integer> request = new ArrayList<Integer>();
        request.add(2);
        Batch batchingContextOk = new Batch(this.integerDescriptor, request, null, null);
        executor.validateBatch(batchingContextOk);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidateFailure() {
        BatchExecutor executor = new BatchExecutor(this.integerDescriptor, new PartitionKey(new Object[]{0}));
        ArrayList<Integer> request = new ArrayList<Integer>();
        request.add(3);
        Batch batchingContextOk = new Batch(this.integerDescriptor, request, null, null);
        executor.validateBatch(batchingContextOk);
    }
}

