/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class FixedHeaderProviderTest {
    @Test
    public void testCreateSuccess() {
        ImmutableMap headers = ImmutableMap.of((Object)"User-Agent", (Object)"hello1", (Object)"Custom-Header", (Object)"hello2");
        FixedHeaderProvider headerProvider = FixedHeaderProvider.create((Map)headers);
        Assert.assertEquals((Object)headers, (Object)headerProvider.getHeaders());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateFail() {
        ImmutableMap headers = ImmutableMap.of((Object)"User-Agent", (Object)"hello1", (Object)"user-agent", (Object)"hello2");
        FixedHeaderProvider.create((Map)headers);
    }

    @Test
    public void testCreateVarargSuccess() {
        ImmutableMap headers = ImmutableMap.of((Object)"User-Agent", (Object)"hello1", (Object)"Custom-Header", (Object)"hello2");
        FixedHeaderProvider headerProvider = FixedHeaderProvider.create((String[])new String[]{"User-Agent", "hello1", "Custom-Header", "hello2"});
        Assert.assertEquals((Object)headers, (Object)headerProvider.getHeaders());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateVarargFail() {
        FixedHeaderProvider.create((String[])new String[]{"User-Agent", "hello1", "user-agent", "hello2"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateVarargOddNumberOfParamsFail() {
        FixedHeaderProvider.create((String[])new String[]{"User-Agent", "hello1", "Custom-Header"});
    }
}

