/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import java.util.Set;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class ServerStreamingCallSettingsTest {
    @Test
    public void retryableCodesAreNotLost() {
        ImmutableSet codes = ImmutableSet.of((Object)StatusCode.Code.UNAVAILABLE, (Object)StatusCode.Code.RESOURCE_EXHAUSTED);
        ServerStreamingCallSettings.Builder builder = ServerStreamingCallSettings.newBuilder();
        builder.setRetryableCodes((Set)codes);
        Truth.assertThat((Iterable)builder.getRetryableCodes()).containsExactlyElementsIn((Iterable)codes);
        Truth.assertThat((Iterable)builder.build().getRetryableCodes()).containsExactlyElementsIn((Iterable)codes);
        Truth.assertThat((Iterable)builder.build().toBuilder().getRetryableCodes()).containsExactlyElementsIn((Iterable)codes);
    }

    @Test
    public void retryableCodesVarArgs() {
        ServerStreamingCallSettings.Builder builder = ServerStreamingCallSettings.newBuilder().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.UNKNOWN, StatusCode.Code.ABORTED});
        Truth.assertThat((Iterable)builder.getRetryableCodes()).containsExactly(new Object[]{StatusCode.Code.UNKNOWN, StatusCode.Code.ABORTED});
    }

    @Test
    public void retryableSettingsAreNotLost() {
        RetrySettings retrySettings = (RetrySettings)Mockito.mock(RetrySettings.class);
        ServerStreamingCallSettings.Builder builder = ServerStreamingCallSettings.newBuilder();
        builder.setRetrySettings(retrySettings);
        Truth.assertThat((Object)builder.getRetrySettings()).isSameInstanceAs((Object)retrySettings);
        Truth.assertThat((Object)builder.build().getRetrySettings()).isSameInstanceAs((Object)retrySettings);
        Truth.assertThat((Object)builder.build().toBuilder().getRetrySettings()).isSameInstanceAs((Object)retrySettings);
    }

    @Test
    public void idleTimeoutIsNotLost() {
        Duration idleTimeout = Duration.ofSeconds((long)5L);
        ServerStreamingCallSettings.Builder builder = ServerStreamingCallSettings.newBuilder();
        builder.setIdleTimeout(idleTimeout);
        Truth.assertThat((Comparable)builder.getIdleTimeout()).isEqualTo((Object)idleTimeout);
        Truth.assertThat((Comparable)builder.build().getIdleTimeout()).isEqualTo((Object)idleTimeout);
        Truth.assertThat((Comparable)builder.build().toBuilder().getIdleTimeout()).isEqualTo((Object)idleTimeout);
    }
}

