/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.NoopApiTracer;
import com.google.api.gax.tracing.OpencensusTracer;
import com.google.api.gax.tracing.OpencensusTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.common.collect.ImmutableMap;
import io.grpc.Context;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanBuilder;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.unsafe.ContextUtils;
import java.util.Map;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class OpencensusTracerFactoryTest {
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();
    @Mock
    private Tracer internalTracer;
    @Mock
    private SpanBuilder spanBuilder;
    @Mock
    private Span span;
    private final Map<String, String> defaultSpanAttributes = ImmutableMap.of();

    @Before
    public void setUp() {
        Mockito.when((Object)this.internalTracer.spanBuilderWithExplicitParent(ArgumentMatchers.anyString(), (Span)ArgumentMatchers.nullable(Span.class))).thenReturn((Object)this.spanBuilder);
        Mockito.when((Object)this.spanBuilder.setRecordEvents(true)).thenReturn((Object)this.spanBuilder);
        Mockito.when((Object)this.spanBuilder.startSpan()).thenReturn((Object)this.span);
    }

    @Test
    public void testSpanNamePassthrough() {
        OpencensusTracerFactory factory = new OpencensusTracerFactory(this.internalTracer, (Map)ImmutableMap.of());
        factory.newTracer(NoopApiTracer.getInstance(), SpanName.of((String)"FakeClient", (String)"FakeMethod"), ApiTracerFactory.OperationType.Unary);
        ((Tracer)Mockito.verify((Object)this.internalTracer)).spanBuilderWithExplicitParent((String)ArgumentMatchers.eq((Object)"FakeClient.FakeMethod"), (Span)ArgumentMatchers.nullable(Span.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImplicitParentSpan() {
        OpencensusTracerFactory factory = new OpencensusTracerFactory(this.internalTracer, this.defaultSpanAttributes);
        Span parentSpan = (Span)Mockito.mock(Span.class);
        Context origContext = ContextUtils.withValue((Context)Context.current(), (Span)parentSpan).attach();
        try {
            factory.newTracer(NoopApiTracer.getInstance(), SpanName.of((String)"FakeClient", (String)"FakeMethod"), ApiTracerFactory.OperationType.Unary);
        }
        finally {
            Context.current().detach(origContext);
        }
        ((Tracer)Mockito.verify((Object)this.internalTracer)).spanBuilderWithExplicitParent(ArgumentMatchers.anyString(), (Span)ArgumentMatchers.same((Object)parentSpan));
    }

    @Test
    public void testExplicitParent() {
        OpencensusTracerFactory factory = new OpencensusTracerFactory(this.internalTracer, this.defaultSpanAttributes);
        Span parentSpan = (Span)Mockito.mock(Span.class);
        OpencensusTracer parentTracer = new OpencensusTracer(this.internalTracer, parentSpan, ApiTracerFactory.OperationType.Unary);
        factory.newTracer((ApiTracer)parentTracer, SpanName.of((String)"FakeClient", (String)"FakeMethod"), ApiTracerFactory.OperationType.Unary);
        ((Tracer)Mockito.verify((Object)this.internalTracer)).spanBuilderWithExplicitParent(ArgumentMatchers.anyString(), (Span)ArgumentMatchers.same((Object)parentSpan));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitParentOverridesImplicit() {
        OpencensusTracerFactory factory = new OpencensusTracerFactory(this.internalTracer, this.defaultSpanAttributes);
        Span parentSpan = (Span)Mockito.mock(Span.class);
        OpencensusTracer parentTracer = new OpencensusTracer(this.internalTracer, parentSpan, ApiTracerFactory.OperationType.Unary);
        Context origContext = ContextUtils.withValue((Context)Context.current(), (Span)parentSpan).attach();
        try {
            factory.newTracer((ApiTracer)parentTracer, SpanName.of((String)"FakeClient", (String)"FakeMethod"), ApiTracerFactory.OperationType.Unary);
        }
        finally {
            Context.current().detach(origContext);
        }
        ((Tracer)Mockito.verify((Object)this.internalTracer)).spanBuilderWithExplicitParent(ArgumentMatchers.anyString(), (Span)ArgumentMatchers.same((Object)parentSpan));
    }

    @Test
    public void testSpanAttributes() {
        OpencensusTracerFactory factory = new OpencensusTracerFactory(this.internalTracer, (Map)ImmutableMap.of((Object)"gax.version", (Object)"1.2.3"));
        factory.newTracer(NoopApiTracer.getInstance(), SpanName.of((String)"FakeClient", (String)"FakeMethod"), ApiTracerFactory.OperationType.Unary);
        ((Span)Mockito.verify((Object)this.span, (VerificationMode)Mockito.times((int)1))).putAttributes((Map)ImmutableMap.of((Object)"gax.version", (Object)AttributeValue.stringAttributeValue((String)"1.2.3")));
    }
}

