/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.TraceFinisher;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class TraceFinisherTest {
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    private ApiTracer mockTracer;

    @Test
    public void testSuccess() {
        ApiFuture future = ApiFutures.immediateFuture((Object)"result");
        ApiFutures.addCallback((ApiFuture)future, (ApiFutureCallback)new TraceFinisher(this.mockTracer), (Executor)MoreExecutors.directExecutor());
        ((ApiTracer)Mockito.verify((Object)this.mockTracer, (VerificationMode)Mockito.times((int)1))).operationSucceeded();
    }

    @Test
    public void testCancellation() {
        ApiFuture future = ApiFutures.immediateCancelledFuture();
        ApiFutures.addCallback((ApiFuture)future, (ApiFutureCallback)new TraceFinisher(this.mockTracer), (Executor)MoreExecutors.directExecutor());
        ((ApiTracer)Mockito.verify((Object)this.mockTracer, (VerificationMode)Mockito.times((int)1))).operationCancelled();
    }

    @Test
    public void testFailure() {
        RuntimeException expectedError = new RuntimeException("fake");
        ApiFuture future = ApiFutures.immediateFailedFuture((Throwable)expectedError);
        ApiFutures.addCallback((ApiFuture)future, (ApiFutureCallback)new TraceFinisher(this.mockTracer), (Executor)MoreExecutors.directExecutor());
        ((ApiTracer)Mockito.verify((Object)this.mockTracer, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)expectedError);
    }
}

