/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiCallContextEnhancer;
import com.google.api.gax.rpc.ApiCallContextEnhancers;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.StreamingCallable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@InternalApi(value="For use by transport-specific implementations")
public class EntryPointStreamingCallable<RequestT, ResponseT>
extends StreamingCallable<RequestT, ResponseT> {
    private final StreamingCallable<RequestT, ResponseT> callable;
    private final ApiCallContext defaultCallContext;
    private final List<ApiCallContextEnhancer> callContextEnhancers;

    public EntryPointStreamingCallable(StreamingCallable<RequestT, ResponseT> callable, ApiCallContext defaultCallContext) {
        this(callable, defaultCallContext, Collections.emptyList());
    }

    public EntryPointStreamingCallable(StreamingCallable<RequestT, ResponseT> callable, ApiCallContext defaultCallContext, List<ApiCallContextEnhancer> callContextEnhancers) {
        this.callable = (StreamingCallable)Preconditions.checkNotNull(callable);
        this.defaultCallContext = (ApiCallContext)Preconditions.checkNotNull((Object)defaultCallContext);
        this.callContextEnhancers = (List)Preconditions.checkNotNull(callContextEnhancers);
    }

    @Override
    public ApiStreamObserver<RequestT> bidiStreamingCall(ApiStreamObserver<ResponseT> responseObserver, ApiCallContext thisCallContext) {
        ApiCallContext newCallContext = ApiCallContextEnhancers.applyEnhancers(this.defaultCallContext, thisCallContext, this.callContextEnhancers);
        return this.callable.bidiStreamingCall(responseObserver, newCallContext);
    }

    @Override
    public void serverStreamingCall(RequestT request, ApiStreamObserver<ResponseT> responseObserver, ApiCallContext thisCallContext) {
        ApiCallContext newCallContext = ApiCallContextEnhancers.applyEnhancers(this.defaultCallContext, thisCallContext, this.callContextEnhancers);
        this.callable.serverStreamingCall(request, responseObserver, newCallContext);
    }

    @Override
    public Iterator<ResponseT> blockingServerStreamingCall(RequestT request, ApiCallContext thisCallContext) {
        ApiCallContext newCallContext = ApiCallContextEnhancers.applyEnhancers(this.defaultCallContext, thisCallContext, this.callContextEnhancers);
        return this.callable.blockingServerStreamingCall(request, newCallContext);
    }

    @Override
    public ApiStreamObserver<RequestT> clientStreamingCall(ApiStreamObserver<ResponseT> responseObserver, ApiCallContext thisCallContext) {
        ApiCallContext newCallContext = ApiCallContextEnhancers.applyEnhancers(this.defaultCallContext, thisCallContext, this.callContextEnhancers);
        return this.callable.clientStreamingCall(responseObserver, newCallContext);
    }
}

