/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiClock;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.Transport;
import com.google.auth.Credentials;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

final class AutoValue_ClientContext
extends ClientContext {
    private final List<BackgroundResource> backgroundResources;
    private final ScheduledExecutorService executor;
    private final Credentials credentials;
    private final Transport transportContext;
    private final ApiClock clock;

    private AutoValue_ClientContext(List<BackgroundResource> backgroundResources, ScheduledExecutorService executor, @Nullable Credentials credentials, Transport transportContext, ApiClock clock) {
        if (backgroundResources == null) {
            throw new NullPointerException("Null backgroundResources");
        }
        this.backgroundResources = backgroundResources;
        if (executor == null) {
            throw new NullPointerException("Null executor");
        }
        this.executor = executor;
        this.credentials = credentials;
        if (transportContext == null) {
            throw new NullPointerException("Null transportContext");
        }
        this.transportContext = transportContext;
        if (clock == null) {
            throw new NullPointerException("Null clock");
        }
        this.clock = clock;
    }

    @Override
    public List<BackgroundResource> getBackgroundResources() {
        return this.backgroundResources;
    }

    @Override
    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    @Nullable
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public Transport getTransportContext() {
        return this.transportContext;
    }

    @Override
    public ApiClock getClock() {
        return this.clock;
    }

    public String toString() {
        return "ClientContext{backgroundResources=" + this.backgroundResources + ", executor=" + this.executor + ", credentials=" + this.credentials + ", transportContext=" + this.transportContext + ", clock=" + this.clock + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ClientContext) {
            ClientContext that = (ClientContext)o;
            return this.backgroundResources.equals(that.getBackgroundResources()) && this.executor.equals(that.getExecutor()) && (this.credentials == null ? that.getCredentials() == null : this.credentials.equals(that.getCredentials())) && this.transportContext.equals(that.getTransportContext()) && this.clock.equals(that.getClock());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.backgroundResources.hashCode();
        h *= 1000003;
        h ^= this.executor.hashCode();
        h *= 1000003;
        h ^= this.credentials == null ? 0 : this.credentials.hashCode();
        h *= 1000003;
        h ^= this.transportContext.hashCode();
        h *= 1000003;
        return h ^= this.clock.hashCode();
    }

    static final class Builder
    extends ClientContext.Builder {
        private List<BackgroundResource> backgroundResources;
        private ScheduledExecutorService executor;
        private Credentials credentials;
        private Transport transportContext;
        private ApiClock clock;

        Builder() {
        }

        Builder(ClientContext source) {
            this.backgroundResources = source.getBackgroundResources();
            this.executor = source.getExecutor();
            this.credentials = source.getCredentials();
            this.transportContext = source.getTransportContext();
            this.clock = source.getClock();
        }

        @Override
        public ClientContext.Builder setBackgroundResources(List<BackgroundResource> backgroundResources) {
            this.backgroundResources = backgroundResources;
            return this;
        }

        @Override
        public ClientContext.Builder setExecutor(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        @Override
        public ClientContext.Builder setCredentials(@Nullable Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public ClientContext.Builder setTransportContext(Transport transportContext) {
            this.transportContext = transportContext;
            return this;
        }

        @Override
        public ClientContext.Builder setClock(ApiClock clock) {
            this.clock = clock;
            return this;
        }

        @Override
        public ClientContext build() {
            String missing = "";
            if (this.backgroundResources == null) {
                missing = missing + " backgroundResources";
            }
            if (this.executor == null) {
                missing = missing + " executor";
            }
            if (this.transportContext == null) {
                missing = missing + " transportContext";
            }
            if (this.clock == null) {
                missing = missing + " clock";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ClientContext(this.backgroundResources, this.executor, this.credentials, this.transportContext, this.clock);
        }
    }
}

