/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.NanoClock;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.FixedWatchdogProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.InstantiatingWatchdogProvider;
import com.google.api.gax.rpc.NoHeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.WatchdogProvider;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.NoopApiTracerFactory;
import com.google.auth.oauth2.QuotaProjectIdProvider;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

public abstract class StubSettings<SettingsT extends StubSettings<SettingsT>> {
    static final String QUOTA_PROJECT_ID_HEADER_KEY = "x-goog-user-project";
    private final ExecutorProvider executorProvider;
    private final CredentialsProvider credentialsProvider;
    private final HeaderProvider headerProvider;
    private final HeaderProvider internalHeaderProvider;
    private final TransportChannelProvider transportChannelProvider;
    private final ApiClock clock;
    private final String endpoint;
    private final String mtlsEndpoint;
    private final String quotaProjectId;
    @Nullable
    private final WatchdogProvider streamWatchdogProvider;
    @Nonnull
    private final Duration streamWatchdogCheckInterval;
    @Nonnull
    private final ApiTracerFactory tracerFactory;
    private final boolean switchToMtlsEndpointAllowed;

    protected StubSettings(Builder builder) {
        this.executorProvider = builder.executorProvider;
        this.transportChannelProvider = builder.transportChannelProvider;
        this.credentialsProvider = builder.credentialsProvider;
        this.headerProvider = builder.headerProvider;
        this.internalHeaderProvider = builder.internalHeaderProvider;
        this.clock = builder.clock;
        this.endpoint = builder.endpoint;
        this.mtlsEndpoint = builder.mtlsEndpoint;
        this.switchToMtlsEndpointAllowed = builder.switchToMtlsEndpointAllowed;
        this.quotaProjectId = builder.quotaProjectId;
        this.streamWatchdogProvider = builder.streamWatchdogProvider;
        this.streamWatchdogCheckInterval = builder.streamWatchdogCheckInterval;
        this.tracerFactory = builder.tracerFactory;
    }

    public final ExecutorProvider getExecutorProvider() {
        return this.executorProvider;
    }

    public final TransportChannelProvider getTransportChannelProvider() {
        return this.transportChannelProvider;
    }

    public final CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public final HeaderProvider getHeaderProvider() {
        return this.headerProvider;
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    protected final HeaderProvider getInternalHeaderProvider() {
        return this.internalHeaderProvider;
    }

    public final ApiClock getClock() {
        return this.clock;
    }

    public final String getEndpoint() {
        return this.endpoint;
    }

    public final String getMtlsEndpoint() {
        return this.mtlsEndpoint;
    }

    final boolean getSwitchToMtlsEndpointAllowed() {
        return this.switchToMtlsEndpointAllowed;
    }

    public final String getQuotaProjectId() {
        return this.quotaProjectId;
    }

    @BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
    @Nullable
    public final WatchdogProvider getStreamWatchdogProvider() {
        return this.streamWatchdogProvider;
    }

    @BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
    @Nonnull
    public final Duration getStreamWatchdogCheckInterval() {
        return this.streamWatchdogCheckInterval;
    }

    @BetaApi(value="The surface for tracing is not stable yet and may change in the future.")
    @Nonnull
    public ApiTracerFactory getTracerFactory() {
        return this.tracerFactory;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("executorProvider", (Object)this.executorProvider).add("transportChannelProvider", (Object)this.transportChannelProvider).add("credentialsProvider", (Object)this.credentialsProvider).add("headerProvider", (Object)this.headerProvider).add("internalHeaderProvider", (Object)this.internalHeaderProvider).add("clock", (Object)this.clock).add("endpoint", (Object)this.endpoint).add("mtlsEndpoint", (Object)this.mtlsEndpoint).add("switchToMtlsEndpointAllowed", this.switchToMtlsEndpointAllowed).add("quotaProjectId", (Object)this.quotaProjectId).add("streamWatchdogProvider", (Object)this.streamWatchdogProvider).add("streamWatchdogCheckInterval", (Object)this.streamWatchdogCheckInterval).add("tracerFactory", (Object)this.tracerFactory).toString();
    }

    public abstract Builder toBuilder();

    public static abstract class Builder<SettingsT extends StubSettings<SettingsT>, B extends Builder<SettingsT, B>> {
        private ExecutorProvider executorProvider;
        private CredentialsProvider credentialsProvider;
        private HeaderProvider headerProvider;
        private HeaderProvider internalHeaderProvider;
        private TransportChannelProvider transportChannelProvider;
        private ApiClock clock;
        private String endpoint;
        private String mtlsEndpoint;
        private String quotaProjectId;
        @Nullable
        private WatchdogProvider streamWatchdogProvider;
        @Nonnull
        private Duration streamWatchdogCheckInterval;
        @Nonnull
        private ApiTracerFactory tracerFactory;
        private boolean switchToMtlsEndpointAllowed = false;

        protected Builder(StubSettings settings) {
            this.executorProvider = settings.executorProvider;
            this.transportChannelProvider = settings.transportChannelProvider;
            this.credentialsProvider = settings.credentialsProvider;
            this.headerProvider = settings.headerProvider;
            this.internalHeaderProvider = settings.internalHeaderProvider;
            this.clock = settings.clock;
            this.endpoint = settings.endpoint;
            this.mtlsEndpoint = settings.mtlsEndpoint;
            this.switchToMtlsEndpointAllowed = settings.switchToMtlsEndpointAllowed;
            this.quotaProjectId = settings.quotaProjectId;
            this.streamWatchdogProvider = settings.streamWatchdogProvider;
            this.streamWatchdogCheckInterval = settings.streamWatchdogCheckInterval;
            this.tracerFactory = settings.tracerFactory;
        }

        private static String getQuotaProjectIdFromClientContext(ClientContext clientContext) {
            if (clientContext.getQuotaProjectId() != null) {
                return clientContext.getQuotaProjectId();
            }
            if (clientContext.getCredentials() instanceof QuotaProjectIdProvider) {
                return ((QuotaProjectIdProvider)clientContext.getCredentials()).getQuotaProjectId();
            }
            if (clientContext.getHeaders().containsKey(StubSettings.QUOTA_PROJECT_ID_HEADER_KEY)) {
                return clientContext.getHeaders().get(StubSettings.QUOTA_PROJECT_ID_HEADER_KEY);
            }
            if (clientContext.getInternalHeaders().containsKey(StubSettings.QUOTA_PROJECT_ID_HEADER_KEY)) {
                return clientContext.getInternalHeaders().get(StubSettings.QUOTA_PROJECT_ID_HEADER_KEY);
            }
            return null;
        }

        protected Builder(ClientContext clientContext) {
            if (clientContext == null) {
                this.executorProvider = InstantiatingExecutorProvider.newBuilder().build();
                this.transportChannelProvider = null;
                this.credentialsProvider = NoCredentialsProvider.create();
                this.headerProvider = new NoHeaderProvider();
                this.internalHeaderProvider = new NoHeaderProvider();
                this.clock = NanoClock.getDefaultClock();
                this.endpoint = null;
                this.mtlsEndpoint = null;
                this.quotaProjectId = null;
                this.streamWatchdogProvider = InstantiatingWatchdogProvider.create();
                this.streamWatchdogCheckInterval = Duration.ofSeconds((long)10L);
                this.tracerFactory = NoopApiTracerFactory.getInstance();
            } else {
                this.executorProvider = FixedExecutorProvider.create(clientContext.getExecutor());
                this.transportChannelProvider = FixedTransportChannelProvider.create(clientContext.getTransportChannel());
                this.credentialsProvider = FixedCredentialsProvider.create(clientContext.getCredentials());
                this.headerProvider = FixedHeaderProvider.create(clientContext.getHeaders());
                this.internalHeaderProvider = FixedHeaderProvider.create(clientContext.getInternalHeaders());
                this.clock = clientContext.getClock();
                this.endpoint = clientContext.getEndpoint();
                if (this.endpoint != null) {
                    this.mtlsEndpoint = this.endpoint.replace("googleapis.com", "mtls.googleapis.com");
                }
                this.streamWatchdogProvider = FixedWatchdogProvider.create(clientContext.getStreamWatchdog());
                this.streamWatchdogCheckInterval = clientContext.getStreamWatchdogCheckInterval();
                this.tracerFactory = clientContext.getTracerFactory();
                this.quotaProjectId = Builder.getQuotaProjectIdFromClientContext(clientContext);
            }
        }

        protected Builder() {
            this((ClientContext)null);
        }

        protected B self() {
            return (B)this;
        }

        public B setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = executorProvider;
            return this.self();
        }

        public B setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider);
            return this.self();
        }

        @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
        public B setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = headerProvider;
            if (this.quotaProjectId == null && headerProvider.getHeaders().containsKey(StubSettings.QUOTA_PROJECT_ID_HEADER_KEY)) {
                this.quotaProjectId = headerProvider.getHeaders().get(StubSettings.QUOTA_PROJECT_ID_HEADER_KEY);
            }
            return this.self();
        }

        @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
        protected B setInternalHeaderProvider(HeaderProvider internalHeaderProvider) {
            this.internalHeaderProvider = internalHeaderProvider;
            if (this.quotaProjectId == null && internalHeaderProvider.getHeaders().containsKey(StubSettings.QUOTA_PROJECT_ID_HEADER_KEY)) {
                this.quotaProjectId = internalHeaderProvider.getHeaders().get(StubSettings.QUOTA_PROJECT_ID_HEADER_KEY);
            }
            return this.self();
        }

        public B setTransportChannelProvider(TransportChannelProvider transportChannelProvider) {
            this.transportChannelProvider = transportChannelProvider;
            return this.self();
        }

        @BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
        public B setStreamWatchdogProvider(@Nullable WatchdogProvider streamWatchdogProvider) {
            this.streamWatchdogProvider = streamWatchdogProvider;
            return this.self();
        }

        public B setClock(ApiClock clock) {
            this.clock = clock;
            return this.self();
        }

        public B setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            this.switchToMtlsEndpointAllowed = false;
            if (this.endpoint != null && this.mtlsEndpoint == null) {
                this.mtlsEndpoint = this.endpoint.replace("googleapis.com", "mtls.googleapis.com");
            }
            return this.self();
        }

        protected B setSwitchToMtlsEndpointAllowed(boolean switchToMtlsEndpointAllowed) {
            this.switchToMtlsEndpointAllowed = switchToMtlsEndpointAllowed;
            return this.self();
        }

        public B setMtlsEndpoint(String mtlsEndpoint) {
            this.mtlsEndpoint = mtlsEndpoint;
            return this.self();
        }

        public B setQuotaProjectId(String quotaProjectId) {
            this.quotaProjectId = quotaProjectId;
            return this.self();
        }

        @BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
        public B setStreamWatchdogCheckInterval(@Nonnull Duration checkInterval) {
            Preconditions.checkNotNull((Object)checkInterval);
            this.streamWatchdogCheckInterval = checkInterval;
            return this.self();
        }

        @BetaApi(value="The surface for tracing is not stable yet and may change in the future.")
        public B setTracerFactory(@Nonnull ApiTracerFactory tracerFactory) {
            Preconditions.checkNotNull((Object)tracerFactory);
            this.tracerFactory = tracerFactory;
            return this.self();
        }

        public ExecutorProvider getExecutorProvider() {
            return this.executorProvider;
        }

        public TransportChannelProvider getTransportChannelProvider() {
            return this.transportChannelProvider;
        }

        public CredentialsProvider getCredentialsProvider() {
            return this.credentialsProvider;
        }

        @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
        public HeaderProvider getHeaderProvider() {
            return this.headerProvider;
        }

        @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
        protected HeaderProvider getInternalHeaderProvider() {
            return this.internalHeaderProvider;
        }

        @BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
        @Nullable
        public WatchdogProvider getStreamWatchdogProvider() {
            return this.streamWatchdogProvider;
        }

        public ApiClock getClock() {
            return this.clock;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getMtlsEndpoint() {
            return this.mtlsEndpoint;
        }

        public String getQuotaProjectId() {
            return this.quotaProjectId;
        }

        @BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
        @Nonnull
        public Duration getStreamWatchdogCheckInterval() {
            return this.streamWatchdogCheckInterval;
        }

        @BetaApi(value="The surface for tracing is not stable yet and may change in the future.")
        @Nonnull
        public ApiTracerFactory getTracerFactory() {
            return this.tracerFactory;
        }

        protected static void applyToAllUnaryMethods(Iterable<UnaryCallSettings.Builder<?, ?>> methodSettingsBuilders, ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            for (UnaryCallSettings.Builder<?, ?> settingsBuilder : methodSettingsBuilders) {
                settingsUpdater.apply(settingsBuilder);
            }
        }

        public abstract <B extends StubSettings<B>> StubSettings<B> build() throws IOException;

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("executorProvider", (Object)this.executorProvider).add("transportChannelProvider", (Object)this.transportChannelProvider).add("credentialsProvider", (Object)this.credentialsProvider).add("headerProvider", (Object)this.headerProvider).add("internalHeaderProvider", (Object)this.internalHeaderProvider).add("clock", (Object)this.clock).add("endpoint", (Object)this.endpoint).add("mtlsEndpoint", (Object)this.mtlsEndpoint).add("switchToMtlsEndpointAllowed", this.switchToMtlsEndpointAllowed).add("quotaProjectId", (Object)this.quotaProjectId).add("streamWatchdogProvider", (Object)this.streamWatchdogProvider).add("streamWatchdogCheckInterval", (Object)this.streamWatchdogCheckInterval).add("tracerFactory", (Object)this.tracerFactory).toString();
        }
    }
}

