/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiCallContextEnhancer;
import com.google.api.gax.rpc.ApiCallContextEnhancers;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.ClientStreamingCallable;
import java.util.Collections;
import java.util.List;

@InternalApi(value="For use by transport-specific implementations")
public class EntryPointClientStreamingCallable<RequestT, ResponseT>
extends ClientStreamingCallable<RequestT, ResponseT> {
    private final ClientStreamingCallable<RequestT, ResponseT> callable;
    private final ApiCallContext defaultCallContext;
    private final List<ApiCallContextEnhancer> callContextEnhancers;

    public EntryPointClientStreamingCallable(ClientStreamingCallable<RequestT, ResponseT> callable, ApiCallContext defaultCallContext) {
        this(callable, defaultCallContext, Collections.emptyList());
    }

    public EntryPointClientStreamingCallable(ClientStreamingCallable<RequestT, ResponseT> callable, ApiCallContext defaultCallContext, List<ApiCallContextEnhancer> callContextEnhancers) {
        this.callable = (ClientStreamingCallable)Preconditions.checkNotNull(callable);
        this.defaultCallContext = (ApiCallContext)Preconditions.checkNotNull((Object)defaultCallContext);
        this.callContextEnhancers = (List)Preconditions.checkNotNull(callContextEnhancers);
    }

    @Override
    public ApiStreamObserver<RequestT> clientStreamingCall(ApiStreamObserver<ResponseT> responseObserver, ApiCallContext thisCallContext) {
        ApiCallContext newCallContext = ApiCallContextEnhancers.applyEnhancers(this.defaultCallContext, thisCallContext, this.callContextEnhancers);
        return this.callable.clientStreamingCall(responseObserver, newCallContext);
    }
}

