package com.google.api.gax.retrying;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Generated;
import org.threeten.bp.Duration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_RetrySettings extends RetrySettings {

  private final Duration totalTimeout;

  private final Duration initialRetryDelay;

  private final double retryDelayMultiplier;

  private final Duration maxRetryDelay;

  private final int maxAttempts;

  private final boolean jittered;

  private final Duration initialRpcTimeout;

  private final double rpcTimeoutMultiplier;

  private final Duration maxRpcTimeout;

  private AutoValue_RetrySettings(
      Duration totalTimeout,
      Duration initialRetryDelay,
      double retryDelayMultiplier,
      Duration maxRetryDelay,
      int maxAttempts,
      boolean jittered,
      Duration initialRpcTimeout,
      double rpcTimeoutMultiplier,
      Duration maxRpcTimeout) {
    this.totalTimeout = totalTimeout;
    this.initialRetryDelay = initialRetryDelay;
    this.retryDelayMultiplier = retryDelayMultiplier;
    this.maxRetryDelay = maxRetryDelay;
    this.maxAttempts = maxAttempts;
    this.jittered = jittered;
    this.initialRpcTimeout = initialRpcTimeout;
    this.rpcTimeoutMultiplier = rpcTimeoutMultiplier;
    this.maxRpcTimeout = maxRpcTimeout;
  }

  @Override
  public Duration getTotalTimeout() {
    return totalTimeout;
  }

  @Override
  public Duration getInitialRetryDelay() {
    return initialRetryDelay;
  }

  @Override
  public double getRetryDelayMultiplier() {
    return retryDelayMultiplier;
  }

  @Override
  public Duration getMaxRetryDelay() {
    return maxRetryDelay;
  }

  @Override
  public int getMaxAttempts() {
    return maxAttempts;
  }

  @VisibleForTesting
  @Deprecated
  @Override
  public boolean isJittered() {
    return jittered;
  }

  @Override
  public Duration getInitialRpcTimeout() {
    return initialRpcTimeout;
  }

  @Override
  public double getRpcTimeoutMultiplier() {
    return rpcTimeoutMultiplier;
  }

  @Override
  public Duration getMaxRpcTimeout() {
    return maxRpcTimeout;
  }

  @Override
  public String toString() {
    return "RetrySettings{"
        + "totalTimeout=" + totalTimeout + ", "
        + "initialRetryDelay=" + initialRetryDelay + ", "
        + "retryDelayMultiplier=" + retryDelayMultiplier + ", "
        + "maxRetryDelay=" + maxRetryDelay + ", "
        + "maxAttempts=" + maxAttempts + ", "
        + "jittered=" + jittered + ", "
        + "initialRpcTimeout=" + initialRpcTimeout + ", "
        + "rpcTimeoutMultiplier=" + rpcTimeoutMultiplier + ", "
        + "maxRpcTimeout=" + maxRpcTimeout
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RetrySettings) {
      RetrySettings that = (RetrySettings) o;
      return this.totalTimeout.equals(that.getTotalTimeout())
          && this.initialRetryDelay.equals(that.getInitialRetryDelay())
          && Double.doubleToLongBits(this.retryDelayMultiplier) == Double.doubleToLongBits(that.getRetryDelayMultiplier())
          && this.maxRetryDelay.equals(that.getMaxRetryDelay())
          && this.maxAttempts == that.getMaxAttempts()
          && this.jittered == that.isJittered()
          && this.initialRpcTimeout.equals(that.getInitialRpcTimeout())
          && Double.doubleToLongBits(this.rpcTimeoutMultiplier) == Double.doubleToLongBits(that.getRpcTimeoutMultiplier())
          && this.maxRpcTimeout.equals(that.getMaxRpcTimeout());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= totalTimeout.hashCode();
    h$ *= 1000003;
    h$ ^= initialRetryDelay.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(retryDelayMultiplier) >>> 32) ^ Double.doubleToLongBits(retryDelayMultiplier));
    h$ *= 1000003;
    h$ ^= maxRetryDelay.hashCode();
    h$ *= 1000003;
    h$ ^= maxAttempts;
    h$ *= 1000003;
    h$ ^= jittered ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= initialRpcTimeout.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(rpcTimeoutMultiplier) >>> 32) ^ Double.doubleToLongBits(rpcTimeoutMultiplier));
    h$ *= 1000003;
    h$ ^= maxRpcTimeout.hashCode();
    return h$;
  }

  private static final long serialVersionUID = 8258475264439710899L;

  @Override
  public RetrySettings.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends RetrySettings.Builder {
    private Duration totalTimeout;
    private Duration initialRetryDelay;
    private double retryDelayMultiplier;
    private Duration maxRetryDelay;
    private int maxAttempts;
    private boolean jittered;
    private Duration initialRpcTimeout;
    private double rpcTimeoutMultiplier;
    private Duration maxRpcTimeout;
    private byte set$0;
    Builder() {
    }
    private Builder(RetrySettings source) {
      this.totalTimeout = source.getTotalTimeout();
      this.initialRetryDelay = source.getInitialRetryDelay();
      this.retryDelayMultiplier = source.getRetryDelayMultiplier();
      this.maxRetryDelay = source.getMaxRetryDelay();
      this.maxAttempts = source.getMaxAttempts();
      this.jittered = source.isJittered();
      this.initialRpcTimeout = source.getInitialRpcTimeout();
      this.rpcTimeoutMultiplier = source.getRpcTimeoutMultiplier();
      this.maxRpcTimeout = source.getMaxRpcTimeout();
      set$0 = (byte) 0xf;
    }
    @Override
    public RetrySettings.Builder setTotalTimeout(Duration totalTimeout) {
      if (totalTimeout == null) {
        throw new NullPointerException("Null totalTimeout");
      }
      this.totalTimeout = totalTimeout;
      return this;
    }
    @Override
    public Duration getTotalTimeout() {
      if (this.totalTimeout == null) {
        throw new IllegalStateException("Property \"totalTimeout\" has not been set");
      }
      return totalTimeout;
    }
    @Override
    public RetrySettings.Builder setInitialRetryDelay(Duration initialRetryDelay) {
      if (initialRetryDelay == null) {
        throw new NullPointerException("Null initialRetryDelay");
      }
      this.initialRetryDelay = initialRetryDelay;
      return this;
    }
    @Override
    public Duration getInitialRetryDelay() {
      if (this.initialRetryDelay == null) {
        throw new IllegalStateException("Property \"initialRetryDelay\" has not been set");
      }
      return initialRetryDelay;
    }
    @Override
    public RetrySettings.Builder setRetryDelayMultiplier(double retryDelayMultiplier) {
      this.retryDelayMultiplier = retryDelayMultiplier;
      set$0 |= 1;
      return this;
    }
    @Override
    public double getRetryDelayMultiplier() {
      if ((set$0 & 1) == 0) {
        throw new IllegalStateException("Property \"retryDelayMultiplier\" has not been set");
      }
      return retryDelayMultiplier;
    }
    @Override
    public RetrySettings.Builder setMaxRetryDelay(Duration maxRetryDelay) {
      if (maxRetryDelay == null) {
        throw new NullPointerException("Null maxRetryDelay");
      }
      this.maxRetryDelay = maxRetryDelay;
      return this;
    }
    @Override
    public Duration getMaxRetryDelay() {
      if (this.maxRetryDelay == null) {
        throw new IllegalStateException("Property \"maxRetryDelay\" has not been set");
      }
      return maxRetryDelay;
    }
    @Override
    public RetrySettings.Builder setMaxAttempts(int maxAttempts) {
      this.maxAttempts = maxAttempts;
      set$0 |= 2;
      return this;
    }
    @Override
    public int getMaxAttempts() {
      if ((set$0 & 2) == 0) {
        throw new IllegalStateException("Property \"maxAttempts\" has not been set");
      }
      return maxAttempts;
    }
    @Override
    public RetrySettings.Builder setJittered(boolean jittered) {
      this.jittered = jittered;
      set$0 |= 4;
      return this;
    }
    @Override
    public boolean isJittered() {
      if ((set$0 & 4) == 0) {
        throw new IllegalStateException("Property \"jittered\" has not been set");
      }
      return jittered;
    }
    @Override
    public RetrySettings.Builder setInitialRpcTimeout(Duration initialRpcTimeout) {
      if (initialRpcTimeout == null) {
        throw new NullPointerException("Null initialRpcTimeout");
      }
      this.initialRpcTimeout = initialRpcTimeout;
      return this;
    }
    @Override
    public Duration getInitialRpcTimeout() {
      if (this.initialRpcTimeout == null) {
        throw new IllegalStateException("Property \"initialRpcTimeout\" has not been set");
      }
      return initialRpcTimeout;
    }
    @Override
    public RetrySettings.Builder setRpcTimeoutMultiplier(double rpcTimeoutMultiplier) {
      this.rpcTimeoutMultiplier = rpcTimeoutMultiplier;
      set$0 |= 8;
      return this;
    }
    @Override
    public double getRpcTimeoutMultiplier() {
      if ((set$0 & 8) == 0) {
        throw new IllegalStateException("Property \"rpcTimeoutMultiplier\" has not been set");
      }
      return rpcTimeoutMultiplier;
    }
    @Override
    public RetrySettings.Builder setMaxRpcTimeout(Duration maxRpcTimeout) {
      if (maxRpcTimeout == null) {
        throw new NullPointerException("Null maxRpcTimeout");
      }
      this.maxRpcTimeout = maxRpcTimeout;
      return this;
    }
    @Override
    public Duration getMaxRpcTimeout() {
      if (this.maxRpcTimeout == null) {
        throw new IllegalStateException("Property \"maxRpcTimeout\" has not been set");
      }
      return maxRpcTimeout;
    }
    @Override
    RetrySettings autoBuild() {
      if (set$0 != 0xf
          || this.totalTimeout == null
          || this.initialRetryDelay == null
          || this.maxRetryDelay == null
          || this.initialRpcTimeout == null
          || this.maxRpcTimeout == null) {
        StringBuilder missing = new StringBuilder();
        if (this.totalTimeout == null) {
          missing.append(" totalTimeout");
        }
        if (this.initialRetryDelay == null) {
          missing.append(" initialRetryDelay");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" retryDelayMultiplier");
        }
        if (this.maxRetryDelay == null) {
          missing.append(" maxRetryDelay");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" maxAttempts");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" jittered");
        }
        if (this.initialRpcTimeout == null) {
          missing.append(" initialRpcTimeout");
        }
        if ((set$0 & 8) == 0) {
          missing.append(" rpcTimeoutMultiplier");
        }
        if (this.maxRpcTimeout == null) {
          missing.append(" maxRpcTimeout");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_RetrySettings(
          this.totalTimeout,
          this.initialRetryDelay,
          this.retryDelayMultiplier,
          this.maxRetryDelay,
          this.maxAttempts,
          this.jittered,
          this.initialRpcTimeout,
          this.rpcTimeoutMultiplier,
          this.maxRpcTimeout);
    }
  }

}
