/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.gax.core.GaxProperties;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GaxPropertiesTest {
    @Test
    public void testGaxVersion() {
        String gaxVersion = GaxProperties.getGaxVersion();
        Assert.assertTrue((boolean)Pattern.compile("^\\d+\\.\\d+\\.\\d+").matcher(gaxVersion).find());
        String[] versionComponents = gaxVersion.split("\\.");
        int major = Integer.parseInt(versionComponents[0]);
        int minor = Integer.parseInt(versionComponents[1]);
        Assert.assertTrue((major >= 1 ? 1 : 0) != 0);
        if (major == 1) {
            Assert.assertTrue((minor >= 56 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetVersion_nativeImage() {
        System.setProperty("org.graalvm.nativeimage.imagecode", "runtime");
        String javaVersion = GaxProperties.getJavaVersion();
        Assert.assertTrue((boolean)javaVersion.endsWith("-graalvm"));
    }
}

