package com.google.api.gax.batching;

import com.google.api.core.SettableApiFuture;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_BatchEntry<ElementT, ElementResultT> extends BatchEntry<ElementT, ElementResultT> {

  private final ElementT element;

  private final SettableApiFuture<ElementResultT> resultFuture;

  AutoValue_BatchEntry(
      @Nullable ElementT element,
      SettableApiFuture<ElementResultT> resultFuture) {
    this.element = element;
    if (resultFuture == null) {
      throw new NullPointerException("Null resultFuture");
    }
    this.resultFuture = resultFuture;
  }

  @Nullable
  @Override
  public ElementT getElement() {
    return element;
  }

  @Override
  public SettableApiFuture<ElementResultT> getResultFuture() {
    return resultFuture;
  }

  @Override
  public String toString() {
    return "BatchEntry{"
        + "element=" + element + ", "
        + "resultFuture=" + resultFuture
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof BatchEntry) {
      BatchEntry<?, ?> that = (BatchEntry<?, ?>) o;
      return (this.element == null ? that.getElement() == null : this.element.equals(that.getElement()))
          && this.resultFuture.equals(that.getResultFuture());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (element == null) ? 0 : element.hashCode();
    h$ *= 1000003;
    h$ ^= resultFuture.hashCode();
    return h$;
  }

}
