/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.AutoValue_EndpointContext;
import com.google.api.gax.rpc.mtls.MtlsProvider;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import javax.annotation.Nullable;

@InternalApi
@AutoValue
public abstract class EndpointContext {
    static final String GOOGLE_DEFAULT_UNIVERSE = "googleapis.com";

    @Nullable
    public abstract String serviceName();

    @Nullable
    public abstract String universeDomain();

    @Nullable
    public abstract String clientSettingsEndpoint();

    @Nullable
    public abstract String transportChannelProviderEndpoint();

    @Nullable
    public abstract String mtlsEndpoint();

    public abstract boolean switchToMtlsEndpointAllowed();

    @Nullable
    public abstract MtlsProvider mtlsProvider();

    public abstract boolean usingGDCH();

    abstract String resolvedUniverseDomain();

    public abstract String resolvedEndpoint();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_EndpointContext.Builder().setSwitchToMtlsEndpointAllowed(false).setUsingGDCH(false);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setServiceName(String var1);

        public abstract Builder setUniverseDomain(String var1);

        public abstract Builder setClientSettingsEndpoint(String var1);

        public abstract Builder setTransportChannelProviderEndpoint(String var1);

        public abstract Builder setMtlsEndpoint(String var1);

        public abstract Builder setSwitchToMtlsEndpointAllowed(boolean var1);

        public abstract Builder setMtlsProvider(MtlsProvider var1);

        public abstract Builder setUsingGDCH(boolean var1);

        public abstract Builder setResolvedEndpoint(String var1);

        public abstract Builder setResolvedUniverseDomain(String var1);

        abstract String serviceName();

        abstract String universeDomain();

        abstract String clientSettingsEndpoint();

        abstract String transportChannelProviderEndpoint();

        abstract String mtlsEndpoint();

        abstract boolean switchToMtlsEndpointAllowed();

        abstract MtlsProvider mtlsProvider();

        abstract boolean usingGDCH();

        abstract String resolvedUniverseDomain();

        abstract EndpointContext autoBuild();

        private String determineUniverseDomain() {
            if (this.usingGDCH()) {
                if (this.universeDomain() != null) {
                    throw new IllegalArgumentException("Universe domain configuration is incompatible with GDC-H");
                }
                return EndpointContext.GOOGLE_DEFAULT_UNIVERSE;
            }
            if (this.universeDomain() != null && this.universeDomain().isEmpty()) {
                throw new IllegalArgumentException("The universe domain value cannot be empty.");
            }
            return this.universeDomain() != null ? this.universeDomain() : EndpointContext.GOOGLE_DEFAULT_UNIVERSE;
        }

        private String determineEndpoint() throws IOException {
            String endpoint;
            String customEndpoint;
            MtlsProvider mtlsProvider = this.mtlsProvider() == null ? new MtlsProvider() : this.mtlsProvider();
            String string = customEndpoint = this.transportChannelProviderEndpoint() == null ? this.clientSettingsEndpoint() : this.transportChannelProviderEndpoint();
            if (this.usingGDCH()) {
                if (customEndpoint == null) {
                    return this.buildEndpointTemplate(this.serviceName(), this.resolvedUniverseDomain());
                }
                return customEndpoint;
            }
            if (Strings.isNullOrEmpty((String)customEndpoint)) {
                customEndpoint = this.buildEndpointTemplate(this.serviceName(), this.resolvedUniverseDomain());
            }
            if ((endpoint = this.mtlsEndpointResolver(customEndpoint, this.mtlsEndpoint(), this.switchToMtlsEndpointAllowed(), mtlsProvider)).equals(this.mtlsEndpoint()) && !this.resolvedUniverseDomain().equals(EndpointContext.GOOGLE_DEFAULT_UNIVERSE)) {
                throw new IllegalArgumentException("mTLS is not supported in any universe other than googleapis.com");
            }
            return endpoint;
        }

        private String buildEndpointTemplate(String serviceName, String resolvedUniverseDomain) {
            return serviceName + "." + resolvedUniverseDomain + ":443";
        }

        @VisibleForTesting
        String mtlsEndpointResolver(String endpoint, String mtlsEndpoint, boolean switchToMtlsEndpointAllowed, MtlsProvider mtlsProvider) throws IOException {
            if (switchToMtlsEndpointAllowed && mtlsProvider != null) {
                switch (mtlsProvider.getMtlsEndpointUsagePolicy()) {
                    case ALWAYS: {
                        return mtlsEndpoint;
                    }
                    case NEVER: {
                        return endpoint;
                    }
                }
                if (mtlsProvider.useMtlsClientCertificate() && mtlsProvider.getKeyStore() != null) {
                    return mtlsEndpoint;
                }
                return endpoint;
            }
            return endpoint;
        }

        public EndpointContext build() throws IOException {
            this.setResolvedUniverseDomain(this.determineUniverseDomain());
            this.setResolvedEndpoint(this.determineEndpoint());
            return this.autoBuild();
        }
    }
}

