/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.testing;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.concurrent.Executor;

@InternalApi(value="for testing")
public class FakePagedApi {

    public static class ListIntegersPagedResponseFactory
    implements PagedListResponseFactory<Integer, List<Integer>, ListIntegersPagedResponse> {
        private final StashPagedListDescriptor streamingDescriptor = new StashPagedListDescriptor();

        public ApiFuture<ListIntegersPagedResponse> getFuturePagedResponse(UnaryCallable<Integer, List<Integer>> callable, Integer request, ApiCallContext context, ApiFuture<List<Integer>> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)this.streamingDescriptor, (Object)request, (ApiCallContext)context);
            return ListIntegersPagedResponse.create((PageContext<Integer, List<Integer>, Integer>)pageContext, futureResponse);
        }
    }

    private static class ListIntegersSizedPage
    extends AbstractFixedSizeCollection<Integer, List<Integer>, Integer, ListIntegersPage, ListIntegersSizedPage> {
        private ListIntegersSizedPage(List<ListIntegersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListIntegersSizedPage createEmptyCollection() {
            return new ListIntegersSizedPage(null, 0);
        }

        protected ListIntegersSizedPage createCollection(List<ListIntegersPage> pages, int collectionSize) {
            return new ListIntegersSizedPage(pages, collectionSize);
        }
    }

    private static class ListIntegersPage
    extends AbstractPage<Integer, List<Integer>, Integer, ListIntegersPage> {
        public ListIntegersPage(PageContext<Integer, List<Integer>, Integer> context, List<Integer> response) {
            super(context, response);
        }

        protected ListIntegersPage createPage(PageContext<Integer, List<Integer>, Integer> context, List<Integer> response) {
            return new ListIntegersPage(context, response);
        }
    }

    public static class ListIntegersPagedResponse
    extends AbstractPagedListResponse<Integer, List<Integer>, Integer, ListIntegersPage, ListIntegersSizedPage> {
        protected ListIntegersPagedResponse(ListIntegersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListIntegersSizedPage.createEmptyCollection());
        }

        public static ListIntegersPagedResponse create(PageContext<Integer, List<Integer>, Integer> context, List<Integer> response) {
            ListIntegersPage page = new ListIntegersPage(context, response);
            return new ListIntegersPagedResponse(page);
        }

        public static ApiFuture<ListIntegersPagedResponse> create(PageContext<Integer, List<Integer>, Integer> context, ApiFuture<List<Integer>> futureResponse) {
            ApiFuture futurePage = new ListIntegersPage(null, null).createPageAsync(context, futureResponse);
            return ApiFutures.transform((ApiFuture)futurePage, (ApiFunction)new ApiFunction<ListIntegersPage, ListIntegersPagedResponse>(){

                public ListIntegersPagedResponse apply(ListIntegersPage input) {
                    return new ListIntegersPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }

    private static class StashPagedListDescriptor
    implements PagedListDescriptor<Integer, List<Integer>, Integer> {
        private StashPagedListDescriptor() {
        }

        public String emptyToken() {
            return "";
        }

        public Integer injectToken(Integer payload, String token) {
            return Integer.parseInt(token);
        }

        public String extractNextToken(List<Integer> payload) {
            int size = payload.size();
            return size == 0 ? this.emptyToken() : payload.get(size - 1).toString();
        }

        public Iterable<Integer> extractResources(List<Integer> payload) {
            return payload;
        }

        public Integer injectPageSize(Integer payload, int pageSize) {
            return payload;
        }

        public Integer extractPageSize(Integer payload) {
            return 3;
        }
    }

    public static class PagedStashCallable
    extends UnaryCallable<Integer, List<Integer>> {
        ApiCallContext context;
        Integer request;
        List<List<Integer>> results;
        int currentResultToReturn = 0;

        public PagedStashCallable(List<List<Integer>> results) {
            this.results = results;
        }

        public ApiFuture<List<Integer>> futureCall(Integer request, ApiCallContext context) {
            this.request = request;
            this.context = context;
            List<Integer> result = this.results.get(this.currentResultToReturn);
            ++this.currentResultToReturn;
            return ApiFutures.immediateFuture(result);
        }
    }
}

