/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.gax.core.GaxProperties;
import com.google.common.base.Strings;
import java.util.regex.Pattern;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GaxPropertiesTest {
    private static String originalJavaVersion = System.getProperty("java.version");
    private static String originalJavaVendor = System.getProperty("java.vendor");
    private static String originalJavaVendorVersion = System.getProperty("java.vendor.version");

    GaxPropertiesTest() {
    }

    @Test
    void testGaxVersion() {
        String gaxVersion = GaxProperties.getGaxVersion();
        Assertions.assertTrue((boolean)Pattern.compile("^\\d+\\.\\d+\\.\\d+").matcher(gaxVersion).find());
        String[] versionComponents = gaxVersion.split("\\.");
        int major = Integer.parseInt(versionComponents[0]);
        int minor = Integer.parseInt(versionComponents[1]);
        Assertions.assertTrue((major >= 1 ? 1 : 0) != 0);
        if (major == 1) {
            Assertions.assertTrue((minor >= 56 ? 1 : 0) != 0);
        }
    }

    @AfterEach
    void cleanup() {
        if (Strings.isNullOrEmpty((String)originalJavaVersion)) {
            System.clearProperty("java.version");
        } else {
            System.setProperty("java.version", originalJavaVersion);
        }
        if (Strings.isNullOrEmpty((String)originalJavaVendor)) {
            System.clearProperty("java.vendor");
        } else {
            System.setProperty("java.vendor", originalJavaVendor);
        }
        if (Strings.isNullOrEmpty((String)originalJavaVendorVersion)) {
            System.clearProperty("java.vendor.version");
        } else {
            System.setProperty("java.vendor.version", originalJavaVendorVersion);
        }
    }

    @Test
    void testGetJavaRuntimeInfo_graalVM() {
        System.setProperty("java.version", "17.0.3");
        System.setProperty("java.vendor", "GraalVM Community");
        System.setProperty("java.vendor.version", "GraalVM CE 22.1.0");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assertions.assertEquals((Object)"17.0.3__GraalVM-Community__GraalVM-CE-22.1.0", (Object)runtimeInfo);
    }

    @Test
    void testGetJavaRuntimeInfo_temurin() {
        System.setProperty("java.version", "11.0.19");
        System.setProperty("java.vendor", "Eclipse Adoptium");
        System.setProperty("java.vendor.version", "Temurin-11.0.19+7");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assertions.assertEquals((Object)"11.0.19__Eclipse-Adoptium__Temurin-11.0.19-7", (Object)runtimeInfo);
    }

    @Test
    void testGetJavaRuntimeInfo_coretto() {
        System.setProperty("java.version", "11.0.19");
        System.setProperty("java.vendor", "Amazon.com Inc.");
        System.setProperty("java.vendor.version", "Corretto-11.0.19.7.1");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assertions.assertEquals((Object)"11.0.19__Amazon.com-Inc.__Corretto-11.0.19.7.1", (Object)runtimeInfo);
    }

    @Test
    void testGetJavaRuntimeInfo_specialCharacters() {
        System.setProperty("java.version", "20%^.&0~.1#45`*");
        System.setProperty("java.vendor", "A^!@#$*B()[]{} C ~%& D-E ?");
        System.setProperty("java.vendor.version", "1!@%$@#.AB!346.9^");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assertions.assertEquals((Object)"20--.-0-.1-45--__A------B-------C-----D-E--__1------.AB-346.9-", (Object)runtimeInfo);
    }

    @Test
    void testGetJavaRuntimeInfo_nullVendorVersion() {
        System.setProperty("java.version", "20.0.1");
        System.setProperty("java.vendor", "Oracle");
        System.clearProperty("java.vendor.version");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assertions.assertEquals((Object)"20.0.1__Oracle", (Object)runtimeInfo);
    }

    @Test
    void testGetJavaRuntimeInfo_nullVendorAndVendorVersion() {
        System.setProperty("java.version", "20.0.1");
        System.clearProperty("java.vendor");
        System.clearProperty("java.vendor.version");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assertions.assertEquals((Object)"20.0.1", (Object)runtimeInfo);
    }

    @Test
    void testGetJavaRuntimeInfo_nullJavaVersion() {
        System.clearProperty("java.version");
        System.setProperty("java.vendor", "oracle");
        System.setProperty("java.vendor.version", "20.0.1");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assertions.assertEquals((Object)"null__oracle__20.0.1", (Object)runtimeInfo);
    }
}

