/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.util;

import com.google.api.gax.util.TimeConversionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;

public class TimeConversionUtilsTest {
    final Duration ttDuration = Duration.ofMillis((long)123L);
    final Instant ttInstant = Instant.ofEpochMilli((long)123L);
    final java.time.Duration jtDuration = java.time.Duration.ofMillis(345L);
    final java.time.Instant jtInstant = java.time.Instant.ofEpochMilli(345L);

    @Test
    void testToJavaTimeDuration_validInput_succeeds() {
        Assertions.assertEquals((long)this.ttDuration.toMillis(), (long)TimeConversionUtils.toJavaTimeDuration((Duration)this.ttDuration).toMillis());
        Assertions.assertNull((Object)TimeConversionUtils.toJavaTimeDuration(null));
    }

    @Test
    void testToThreetenTimeDuration_validInput_succeeds() {
        Assertions.assertEquals((long)this.jtDuration.toMillis(), (long)TimeConversionUtils.toThreetenDuration((java.time.Duration)this.jtDuration).toMillis());
        Assertions.assertNull((Object)TimeConversionUtils.toThreetenDuration(null));
    }

    @Test
    void testToJavaTimeInstant_validInput_succeeds() {
        Assertions.assertEquals((long)this.ttInstant.toEpochMilli(), (long)TimeConversionUtils.toJavaTimeInstant((Instant)this.ttInstant).toEpochMilli());
        Assertions.assertNull((Object)TimeConversionUtils.toJavaTimeInstant(null));
    }

    @Test
    void testToThreetenTimeInstant_validInput_succeeds() {
        Assertions.assertEquals((long)this.jtInstant.toEpochMilli(), (long)TimeConversionUtils.toThreetenInstant((java.time.Instant)this.jtInstant).toEpochMilli());
        Assertions.assertNull((Object)TimeConversionUtils.toThreetenInstant(null));
    }
}

