/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.mtls;

import com.google.api.gax.rpc.mtls.MtlsProvider;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MtlsProviderTest {
    MtlsProviderTest() {
    }

    @Test
    void testUseMtlsEndpointAlways() {
        MtlsProvider mtlsProvider = new MtlsProvider(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "always" : "false", (MtlsProvider.ProcessProvider)new TestProcessProvider(0), "/path/to/missing/file");
        Assertions.assertEquals((Object)MtlsProvider.MtlsEndpointUsagePolicy.ALWAYS, (Object)mtlsProvider.getMtlsEndpointUsagePolicy());
    }

    @Test
    void testUseMtlsEndpointAuto() {
        MtlsProvider mtlsProvider = new MtlsProvider(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "auto" : "false", (MtlsProvider.ProcessProvider)new TestProcessProvider(0), "/path/to/missing/file");
        Assertions.assertEquals((Object)MtlsProvider.MtlsEndpointUsagePolicy.AUTO, (Object)mtlsProvider.getMtlsEndpointUsagePolicy());
    }

    @Test
    void testUseMtlsEndpointNever() {
        MtlsProvider mtlsProvider = new MtlsProvider(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "never" : "false", (MtlsProvider.ProcessProvider)new TestProcessProvider(0), "/path/to/missing/file");
        Assertions.assertEquals((Object)MtlsProvider.MtlsEndpointUsagePolicy.NEVER, (Object)mtlsProvider.getMtlsEndpointUsagePolicy());
    }

    @Test
    void testUseMtlsClientCertificateTrue() {
        MtlsProvider mtlsProvider = new MtlsProvider(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "auto" : "true", (MtlsProvider.ProcessProvider)new TestProcessProvider(0), "/path/to/missing/file");
        Assertions.assertTrue((boolean)mtlsProvider.useMtlsClientCertificate());
    }

    @Test
    void testUseMtlsClientCertificateFalse() {
        MtlsProvider mtlsProvider = new MtlsProvider(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "auto" : "false", (MtlsProvider.ProcessProvider)new TestProcessProvider(0), "/path/to/missing/file");
        Assertions.assertFalse((boolean)mtlsProvider.useMtlsClientCertificate());
    }

    @Test
    void testGetKeyStore() throws IOException {
        MtlsProvider mtlsProvider = new MtlsProvider(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "always" : "false", (MtlsProvider.ProcessProvider)new TestProcessProvider(0), "/path/to/missing/file");
        Assertions.assertNull((Object)mtlsProvider.getKeyStore());
    }

    @Test
    void testGetKeyStoreNonZeroExitCode() throws IOException, InterruptedException, GeneralSecurityException {
        InputStream metadata = this.getClass().getClassLoader().getResourceAsStream("com/google/api/gax/rpc/mtls/mtlsCertAndKey.pem");
        IOException actual = (IOException)Assertions.assertThrows(IOException.class, () -> MtlsProvider.getKeyStore((InputStream)metadata, (MtlsProvider.ProcessProvider)new TestProcessProvider(1)));
        Assertions.assertTrue((boolean)actual.getMessage().contains("Cert provider command failed with exit code: 1"), (String)"expected to fail with nonzero exit code");
    }

    @Test
    void testExtractCertificateProviderCommand() throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("com/google/api/gax/rpc/mtls/mtls_context_aware_metadata.json");
        ImmutableList command = MtlsProvider.extractCertificateProviderCommand((InputStream)inputStream);
        Assertions.assertEquals((int)2, (int)command.size());
        Assertions.assertEquals((Object)"some_binary", command.get(0));
        Assertions.assertEquals((Object)"some_argument", command.get(1));
    }

    @Test
    void testRunCertificateProviderCommandSuccess() throws IOException, InterruptedException {
        TestCertProviderCommandProcess certCommandProcess = new TestCertProviderCommandProcess(0, false);
        int exitValue = MtlsProvider.runCertificateProviderCommand((Process)certCommandProcess, (long)100L);
        Assertions.assertEquals((int)0, (int)exitValue);
    }

    @Test
    void testRunCertificateProviderCommandTimeout() throws InterruptedException {
        TestCertProviderCommandProcess certCommandProcess = new TestCertProviderCommandProcess(0, true);
        IOException actual = (IOException)Assertions.assertThrows(IOException.class, () -> MtlsProvider.runCertificateProviderCommand((Process)certCommandProcess, (long)100L));
        Assertions.assertTrue((boolean)actual.getMessage().contains("cert provider command timed out"), (String)"expected to fail with timeout");
    }

    static class TestProcessProvider
    implements MtlsProvider.ProcessProvider {
        private int exitCode;

        public TestProcessProvider(int exitCode) {
            this.exitCode = exitCode;
        }

        public Process createProcess(InputStream metadata) throws IOException {
            return new TestCertProviderCommandProcess(this.exitCode, false);
        }
    }

    private static class TestCertProviderCommandProcess
    extends Process {
        private boolean runForever;
        private int exitValue;

        public TestCertProviderCommandProcess(int exitValue, boolean runForever) {
            this.runForever = runForever;
            this.exitValue = exitValue;
        }

        @Override
        public OutputStream getOutputStream() {
            return null;
        }

        @Override
        public InputStream getInputStream() {
            return null;
        }

        @Override
        public InputStream getErrorStream() {
            return null;
        }

        @Override
        public int waitFor() throws InterruptedException {
            return 0;
        }

        @Override
        public int exitValue() {
            if (this.runForever) {
                throw new IllegalThreadStateException();
            }
            return this.exitValue;
        }

        @Override
        public void destroy() {
        }
    }
}

