/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.gax.core.GaxProperties;
import com.google.common.base.Strings;
import com.google.protobuf.Any;
import java.io.IOException;
import java.util.Optional;
import java.util.regex.Pattern;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GaxPropertiesTest {
    private static String originalJavaVersion = System.getProperty("java.version");
    private static String originalJavaVendor = System.getProperty("java.vendor");
    private static String originalJavaVendorVersion = System.getProperty("java.vendor.version");

    GaxPropertiesTest() {
    }

    @Test
    void testGaxVersion() {
        Version version = this.readVersion(GaxProperties.getGaxVersion());
        Assertions.assertTrue((version.major >= 1 ? 1 : 0) != 0);
        if (version.major == 1) {
            Assertions.assertTrue((version.minor >= 56 ? 1 : 0) != 0);
        }
    }

    @AfterEach
    void cleanup() {
        if (Strings.isNullOrEmpty((String)originalJavaVersion)) {
            System.clearProperty("java.version");
        } else {
            System.setProperty("java.version", originalJavaVersion);
        }
        if (Strings.isNullOrEmpty((String)originalJavaVendor)) {
            System.clearProperty("java.vendor");
        } else {
            System.setProperty("java.vendor", originalJavaVendor);
        }
        if (Strings.isNullOrEmpty((String)originalJavaVendorVersion)) {
            System.clearProperty("java.vendor.version");
        } else {
            System.setProperty("java.vendor.version", originalJavaVendorVersion);
        }
    }

    @Test
    void testGetJavaRuntimeInfo_graalVM() {
        System.setProperty("java.version", "17.0.3");
        System.setProperty("java.vendor", "GraalVM Community");
        System.setProperty("java.vendor.version", "GraalVM CE 22.1.0");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assertions.assertEquals((Object)"17.0.3__GraalVM-Community__GraalVM-CE-22.1.0", (Object)runtimeInfo);
    }

    @Test
    void testGetJavaRuntimeInfo_temurin() {
        System.setProperty("java.version", "11.0.19");
        System.setProperty("java.vendor", "Eclipse Adoptium");
        System.setProperty("java.vendor.version", "Temurin-11.0.19+7");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assertions.assertEquals((Object)"11.0.19__Eclipse-Adoptium__Temurin-11.0.19-7", (Object)runtimeInfo);
    }

    @Test
    void testGetJavaRuntimeInfo_coretto() {
        System.setProperty("java.version", "11.0.19");
        System.setProperty("java.vendor", "Amazon.com Inc.");
        System.setProperty("java.vendor.version", "Corretto-11.0.19.7.1");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assertions.assertEquals((Object)"11.0.19__Amazon.com-Inc.__Corretto-11.0.19.7.1", (Object)runtimeInfo);
    }

    @Test
    void testGetJavaRuntimeInfo_specialCharacters() {
        System.setProperty("java.version", "20%^.&0~.1#45`*");
        System.setProperty("java.vendor", "A^!@#$*B()[]{} C ~%& D-E ?");
        System.setProperty("java.vendor.version", "1!@%$@#.AB!346.9^");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assertions.assertEquals((Object)"20--.-0-.1-45--__A------B-------C-----D-E--__1------.AB-346.9-", (Object)runtimeInfo);
    }

    @Test
    void testGetJavaRuntimeInfo_nullVendorVersion() {
        System.setProperty("java.version", "20.0.1");
        System.setProperty("java.vendor", "Oracle");
        System.clearProperty("java.vendor.version");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assertions.assertEquals((Object)"20.0.1__Oracle", (Object)runtimeInfo);
    }

    @Test
    void testGetJavaRuntimeInfo_nullVendorAndVendorVersion() {
        System.setProperty("java.version", "20.0.1");
        System.clearProperty("java.vendor");
        System.clearProperty("java.vendor.version");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assertions.assertEquals((Object)"20.0.1", (Object)runtimeInfo);
    }

    @Test
    void testGetJavaRuntimeInfo_nullJavaVersion() {
        System.clearProperty("java.version");
        System.setProperty("java.vendor", "oracle");
        System.setProperty("java.vendor.version", "20.0.1");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assertions.assertEquals((Object)"null__oracle__20.0.1", (Object)runtimeInfo);
    }

    @Test
    public void testGetProtobufVersion() throws IOException {
        Assertions.assertTrue((boolean)Pattern.compile("^\\d+\\.\\d+\\.\\d+").matcher(GaxProperties.getProtobufVersion()).find());
    }

    @Test
    public void testGetBundleVersion_noManifestFile() throws IOException {
        Optional version = GaxProperties.getBundleVersion(GaxProperties.class);
        Assertions.assertFalse((boolean)version.isPresent());
    }

    @Test
    void testGetProtobufVersion_success() {
        String version = GaxProperties.getProtobufVersion(Any.class, (String)"com.google.api.gax.core.GaxPropertiesTest$RuntimeVersion");
        Assertions.assertEquals((Object)"3.13.6", (Object)version);
    }

    @Test
    void testGetProtobufVersion_classNotFoundException() throws Exception {
        String version = GaxProperties.getProtobufVersion(Any.class, (String)"foo.NonExistantClass");
        Assertions.assertTrue((boolean)Pattern.compile("^\\d+\\.\\d+\\.\\d+").matcher(version).find());
    }

    @Test
    void testgetProtobufVersion_noSuchFieldException() throws Exception {
        String version = GaxProperties.getProtobufVersion(Any.class, (String)"java.lang.Class");
        Assertions.assertTrue((boolean)Pattern.compile("^\\d+\\.\\d+\\.\\d+").matcher(version).find());
    }

    @Test
    void testGetProtobufVersion_noManifest() throws Exception {
        String version = GaxProperties.getProtobufVersion(GaxProperties.class, (String)"foo.NonExistantClass");
        Assertions.assertEquals((Object)"3", (Object)version);
    }

    private Version readVersion(String version) {
        Assertions.assertTrue((boolean)Pattern.compile("^\\d+\\.\\d+\\.\\d+").matcher(version).find());
        String[] versionComponents = version.split("\\.");
        int major = Integer.parseInt(versionComponents[0]);
        int minor = Integer.parseInt(versionComponents[1]);
        return new Version(major, minor);
    }

    private static class Version {
        public int major;
        public int minor;

        public Version(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }
    }

    class RuntimeVersion {
        public static final int MAJOR = 3;
        public static final int MINOR = 13;
        public static final int PATCH = 6;

        RuntimeVersion() {
        }
    }
}

