/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auth.oauth2.ServiceAccountJwtAccessCredentials;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.security.PrivateKey;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class GoogleCredentialsProviderTest {
    GoogleCredentialsProviderTest() {
    }

    ServiceAccountCredentials CreateServiceAccountCredentials() {
        return ServiceAccountCredentials.newBuilder().setClientId("fake-client-id").setClientEmail("fake@example.com").setPrivateKeyId("fake-private-key").setPrivateKey((PrivateKey)Mockito.mock(PrivateKey.class)).build();
    }

    @Test
    void serviceAccountReplacedWithJwtTokens() throws Exception {
        ServiceAccountCredentials serviceAccountCredentials = this.CreateServiceAccountCredentials();
        GoogleCredentialsProvider provider = GoogleCredentialsProvider.newBuilder().setScopesToApply((List)ImmutableList.of((Object)"scope1", (Object)"scope2")).setJwtEnabledScopes((List)ImmutableList.of((Object)"scope1")).setOAuth2Credentials((GoogleCredentials)serviceAccountCredentials).build();
        Credentials credentials = provider.getCredentials();
        Truth.assertThat((Object)credentials).isInstanceOf(ServiceAccountJwtAccessCredentials.class);
        ServiceAccountJwtAccessCredentials jwtCreds = (ServiceAccountJwtAccessCredentials)credentials;
        Truth.assertThat((String)jwtCreds.getClientId()).isEqualTo((Object)serviceAccountCredentials.getClientId());
        Truth.assertThat((String)jwtCreds.getClientEmail()).isEqualTo((Object)serviceAccountCredentials.getClientEmail());
        Truth.assertThat((String)jwtCreds.getPrivateKeyId()).isEqualTo((Object)serviceAccountCredentials.getPrivateKeyId());
        Truth.assertThat((Object)jwtCreds.getPrivateKey()).isEqualTo((Object)serviceAccountCredentials.getPrivateKey());
    }

    @Test
    void noJwtWithoutScopeMatch() throws Exception {
        ServiceAccountCredentials serviceAccountCredentials = this.CreateServiceAccountCredentials();
        GoogleCredentialsProvider provider = GoogleCredentialsProvider.newBuilder().setScopesToApply((List)ImmutableList.of((Object)"scope1", (Object)"scope2")).setJwtEnabledScopes((List)ImmutableList.of((Object)"other")).setOAuth2Credentials((GoogleCredentials)serviceAccountCredentials).build();
        Credentials credentials = provider.getCredentials();
        Truth.assertThat((Object)credentials).isInstanceOf(ServiceAccountCredentials.class);
        ServiceAccountCredentials serviceAccountCredentials2 = (ServiceAccountCredentials)credentials;
        Truth.assertThat((String)serviceAccountCredentials2.getClientId()).isEqualTo((Object)serviceAccountCredentials.getClientId());
        Truth.assertThat((String)serviceAccountCredentials2.getClientEmail()).isEqualTo((Object)serviceAccountCredentials.getClientEmail());
        Truth.assertThat((String)serviceAccountCredentials2.getPrivateKeyId()).isEqualTo((Object)serviceAccountCredentials.getPrivateKeyId());
        Truth.assertThat((Object)serviceAccountCredentials2.getPrivateKey()).isEqualTo((Object)serviceAccountCredentials.getPrivateKey());
        Truth.assertThat((Iterable)serviceAccountCredentials2.getScopes()).containsExactly(new Object[]{"scope1", "scope2"});
    }

    @Test
    void useJwtAccessWithScope() throws Exception {
        ServiceAccountCredentials serviceAccountCredentials = this.CreateServiceAccountCredentials();
        GoogleCredentialsProvider provider = GoogleCredentialsProvider.newBuilder().setScopesToApply((List)ImmutableList.of((Object)"scope1", (Object)"scope2")).setOAuth2Credentials((GoogleCredentials)serviceAccountCredentials).setUseJwtAccessWithScope(true).build();
        Credentials credentials = provider.getCredentials();
        Truth.assertThat((Object)credentials).isInstanceOf(ServiceAccountCredentials.class);
        ServiceAccountCredentials serviceAccountCredentials2 = (ServiceAccountCredentials)credentials;
        Truth.assertThat((String)serviceAccountCredentials2.getClientId()).isEqualTo((Object)serviceAccountCredentials.getClientId());
        Truth.assertThat((String)serviceAccountCredentials2.getClientEmail()).isEqualTo((Object)serviceAccountCredentials.getClientEmail());
        Truth.assertThat((String)serviceAccountCredentials2.getPrivateKeyId()).isEqualTo((Object)serviceAccountCredentials.getPrivateKeyId());
        Truth.assertThat((Object)serviceAccountCredentials2.getPrivateKey()).isEqualTo((Object)serviceAccountCredentials.getPrivateKey());
        Assertions.assertTrue((boolean)serviceAccountCredentials2.getUseJwtAccessWithScope());
    }
}

