/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.testing;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.api.gax.batching.BatchEntry;
import com.google.api.gax.batching.BatchingRequestBuilder;
import com.google.api.gax.batching.PartitionKey;
import com.google.api.gax.batching.RequestBuilder;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.BatchedRequestIssuer;
import com.google.api.gax.rpc.BatchingDescriptor;
import com.google.api.gax.rpc.UnaryCallable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@InternalApi(value="for testing")
public class FakeBatchableApi {
    public static LabeledIntSquarerCallable callLabeledIntSquarer = new LabeledIntSquarerCallable();
    public static SquarerBatchingDescriptor SQUARER_BATCHING_DESC = new SquarerBatchingDescriptor();
    public static SquarerBatchingDescriptorV2 SQUARER_BATCHING_DESC_V2 = new SquarerBatchingDescriptorV2();

    public static class LabeledIntSquarerCallable
    extends UnaryCallable<LabeledIntList, List<Integer>> {
        public ApiFuture<List<Integer>> futureCall(LabeledIntList request, ApiCallContext context) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (Integer i : request.ints) {
                result.add(i * i);
            }
            return ApiFutures.immediateFuture(result);
        }
    }

    public static class SquarerBatchingDescriptor
    implements BatchingDescriptor<LabeledIntList, List<Integer>> {
        public PartitionKey getBatchPartitionKey(LabeledIntList request) {
            return new PartitionKey(new Object[]{request.label});
        }

        public RequestBuilder<LabeledIntList> getRequestBuilder() {
            return new RequestBuilder<LabeledIntList>(){
                LabeledIntList list;

                public void appendRequest(LabeledIntList request) {
                    if (this.list == null) {
                        this.list = request;
                    } else {
                        this.list.ints.addAll(request.ints);
                    }
                }

                public LabeledIntList build() {
                    return this.list;
                }
            };
        }

        public void splitResponse(List<Integer> batchResponse, Collection<? extends BatchedRequestIssuer<List<Integer>>> batch) {
            int batchMessageIndex = 0;
            for (BatchedRequestIssuer<List<Integer>> batchedRequestIssuer : batch) {
                ArrayList<Integer> messageIds = new ArrayList<Integer>();
                long messageCount = batchedRequestIssuer.getMessageCount();
                int i = 0;
                while ((long)i < messageCount) {
                    messageIds.add(batchResponse.get(batchMessageIndex));
                    ++batchMessageIndex;
                    ++i;
                }
                batchedRequestIssuer.setResponse(messageIds);
            }
        }

        public void splitException(Throwable throwable, Collection<? extends BatchedRequestIssuer<List<Integer>>> batch) {
            for (BatchedRequestIssuer<List<Integer>> batchedRequestIssuer : batch) {
                batchedRequestIssuer.setException(throwable);
            }
        }

        public long countElements(LabeledIntList request) {
            return request.ints.size();
        }

        public long countBytes(LabeledIntList request) {
            long counter = 0L;
            for (Integer i : request.ints) {
                counter += (long)i.intValue();
            }
            return Math.min(counter, 5L);
        }
    }

    public static class SquarerBatchingDescriptorV2
    implements com.google.api.gax.batching.BatchingDescriptor<Integer, Integer, LabeledIntList, List<Integer>> {
        public BatchingRequestBuilder<Integer, LabeledIntList> newRequestBuilder(final LabeledIntList prototype) {
            return new BatchingRequestBuilder<Integer, LabeledIntList>(){
                final LabeledIntList labelList;
                {
                    this.labelList = prototype.clone();
                }

                public void add(Integer element) {
                    this.labelList.ints.add(element);
                }

                public LabeledIntList build() {
                    return this.labelList;
                }
            };
        }

        public void splitResponse(List<Integer> batchResponse, List<BatchEntry<Integer, Integer>> batch) {
            for (int i = 0; i < batchResponse.size(); ++i) {
                batch.get(i).getResultFuture().set((Object)batchResponse.get(i));
            }
        }

        public void splitException(Throwable throwable, List<BatchEntry<Integer, Integer>> batch) {
            for (BatchEntry<Integer, Integer> entry : batch) {
                entry.getResultFuture().setException(throwable);
            }
        }

        public long countBytes(Integer element) {
            return 1L;
        }
    }

    public static class LabeledIntList {
        public String label;
        public List<Integer> ints;

        public LabeledIntList(String label, Integer ... numbers) {
            this(label, new ArrayList<Integer>(Arrays.asList(numbers)));
        }

        public LabeledIntList(String label, List<Integer> ints) {
            this.label = label;
            this.ints = ints;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LabeledIntList that = (LabeledIntList)o;
            if (!this.label.equals(that.label)) {
                return false;
            }
            return this.ints.equals(that.ints);
        }

        public int hashCode() {
            int result = this.label.hashCode();
            result = 31 * result + this.ints.hashCode();
            return result;
        }

        public LabeledIntList clone() {
            return new LabeledIntList(this.label, new ArrayList<Integer>(this.ints));
        }
    }
}

