/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.util;

import com.google.api.gax.util.TimeConversionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;

public class TimeConversionUtilsTest {
    final long MAX_DURATION_NANOS = 999999999L;
    final Duration ttDuration = Duration.ofMillis((long)123L);
    final Instant ttInstant = Instant.ofEpochMilli((long)123L);
    final java.time.Duration jtDuration = java.time.Duration.ofMillis(345L);
    final java.time.Instant jtInstant = java.time.Instant.ofEpochMilli(345L);

    @Test
    void testToJavaTimeDuration_validInput_succeeds() {
        Assertions.assertEquals((long)this.ttDuration.toMillis(), (long)TimeConversionUtils.toJavaTimeDuration((Duration)this.ttDuration).toMillis());
        Assertions.assertNull((Object)TimeConversionUtils.toJavaTimeDuration(null));
    }

    @Test
    void testToThreetenTimeDuration_validInput_succeeds() {
        Assertions.assertEquals((long)this.jtDuration.toMillis(), (long)TimeConversionUtils.toThreetenDuration((java.time.Duration)this.jtDuration).toMillis());
        Assertions.assertNull((Object)TimeConversionUtils.toThreetenDuration(null));
    }

    @Test
    void testToJavaTimeInstant_validInput_succeeds() {
        Assertions.assertEquals((long)this.ttInstant.toEpochMilli(), (long)TimeConversionUtils.toJavaTimeInstant((Instant)this.ttInstant).toEpochMilli());
        Assertions.assertNull((Object)TimeConversionUtils.toJavaTimeInstant(null));
    }

    @Test
    void testToThreetenTimeInstant_validInput_succeeds() {
        Assertions.assertEquals((long)this.jtInstant.toEpochMilli(), (long)TimeConversionUtils.toThreetenInstant((java.time.Instant)this.jtInstant).toEpochMilli());
        Assertions.assertNull((Object)TimeConversionUtils.toThreetenInstant(null));
    }

    @Test
    void testToThreeteenInstant_bigInput_doesNotOverflow() {
        java.time.Instant jtInstant = java.time.Instant.MAX;
        Instant ttInstant = TimeConversionUtils.toThreetenInstant((java.time.Instant)jtInstant);
        Assertions.assertEquals((long)jtInstant.getEpochSecond(), (long)ttInstant.getEpochSecond());
        Assertions.assertEquals((int)jtInstant.getNano(), (int)ttInstant.getNano());
    }

    @Test
    void testToJavaTimeInstant_bigInput_doesNotOverflow() {
        Instant ttInstant = Instant.MAX;
        java.time.Instant jtInstant = TimeConversionUtils.toJavaTimeInstant((Instant)ttInstant);
        Assertions.assertEquals((long)jtInstant.getEpochSecond(), (long)ttInstant.getEpochSecond());
        Assertions.assertEquals((int)jtInstant.getNano(), (int)ttInstant.getNano());
    }

    @Test
    void testToThreeteenDuration_bigInput_doesNotOverflow() {
        java.time.Duration jtDuration = java.time.Duration.ofSeconds(Long.MAX_VALUE, 999999999L);
        Duration ttDuration = TimeConversionUtils.toThreetenDuration((java.time.Duration)jtDuration);
        Assertions.assertEquals((long)jtDuration.getSeconds(), (long)ttDuration.getSeconds());
        Assertions.assertEquals((int)jtDuration.getNano(), (int)ttDuration.getNano());
    }

    @Test
    void testToJavaTimeDuration_bigInput_doesNotOverflow() {
        Duration ttDuration = Duration.ofSeconds((long)Long.MAX_VALUE, (long)999999999L);
        java.time.Duration jtDuration = TimeConversionUtils.toJavaTimeDuration((Duration)ttDuration);
        Assertions.assertEquals((long)jtDuration.getSeconds(), (long)ttDuration.getSeconds());
        Assertions.assertEquals((int)jtDuration.getNano(), (int)ttDuration.getNano());
    }
}

