/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.logging.v2.BillingLogNameType;

public class BillingLogName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}/logs/{log}");
    private final String billingAccount;
    private final String log;

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public String getLog() {
        return this.log;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private BillingLogName(Builder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.log = (String)Preconditions.checkNotNull((Object)builder.getLog());
    }

    public static BillingLogName create(String billingAccount, String log) {
        return BillingLogName.newBuilder().setBillingAccount(billingAccount).setLog(log).build();
    }

    public static BillingLogName parse(String formattedString) {
        ImmutableMap matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "BillingLogName.parse: formattedString not in valid format");
        return BillingLogName.create((String)matchMap.get((Object)"billing_account"), (String)matchMap.get((Object)"log"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return BillingLogNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"billing_account", this.billingAccount, "log", this.log});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BillingLogName) {
            BillingLogName that = (BillingLogName)o;
            return this.billingAccount.equals(that.billingAccount) && this.log.equals(that.log);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.billingAccount.hashCode();
        h *= 1000003;
        return h ^= this.log.hashCode();
    }

    public static class Builder {
        private String billingAccount;
        private String log;

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getLog() {
            return this.log;
        }

        public Builder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public Builder setLog(String log) {
            this.log = log;
            return this;
        }

        private Builder() {
        }

        private Builder(BillingLogName billingLogName) {
            this.billingAccount = billingLogName.billingAccount;
            this.log = billingLogName.log;
        }

        public BillingLogName build() {
            return new BillingLogName(this);
        }
    }
}

