/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.logging.v2.FolderNameType;

public class FolderName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}");
    private final String folder;

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private FolderName(Builder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
    }

    public static FolderName create(String folder) {
        return FolderName.newBuilder().setFolder(folder).build();
    }

    public static FolderName parse(String formattedString) {
        ImmutableMap matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "FolderName.parse: formattedString not in valid format");
        return FolderName.create((String)matchMap.get((Object)"folder"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return FolderNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"folder", this.folder});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FolderName) {
            FolderName that = (FolderName)o;
            return this.folder.equals(that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.folder.hashCode();
    }

    public static class Builder {
        private String folder;

        public String getFolder() {
            return this.folder;
        }

        public Builder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        private Builder() {
        }

        private Builder(FolderName folderName) {
            this.folder = folderName.folder;
        }

        public FolderName build() {
            return new FolderName(this);
        }
    }
}

