/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.logging.v2.FolderSinkNameType;

public class FolderSinkName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/sinks/{sink}");
    private final String folder;
    private final String sink;

    public String getFolder() {
        return this.folder;
    }

    public String getSink() {
        return this.sink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private FolderSinkName(Builder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.sink = (String)Preconditions.checkNotNull((Object)builder.getSink());
    }

    public static FolderSinkName create(String folder, String sink) {
        return FolderSinkName.newBuilder().setFolder(folder).setSink(sink).build();
    }

    public static FolderSinkName parse(String formattedString) {
        ImmutableMap matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "FolderSinkName.parse: formattedString not in valid format");
        return FolderSinkName.create((String)matchMap.get((Object)"folder"), (String)matchMap.get((Object)"sink"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return FolderSinkNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"folder", this.folder, "sink", this.sink});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FolderSinkName) {
            FolderSinkName that = (FolderSinkName)o;
            return this.folder.equals(that.folder) && this.sink.equals(that.sink);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.folder.hashCode();
        h *= 1000003;
        return h ^= this.sink.hashCode();
    }

    public static class Builder {
        private String folder;
        private String sink;

        public String getFolder() {
            return this.folder;
        }

        public String getSink() {
            return this.sink;
        }

        public Builder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public Builder setSink(String sink) {
            this.sink = sink;
            return this;
        }

        private Builder() {
        }

        private Builder(FolderSinkName folderSinkName) {
            this.folder = folderSinkName.folder;
            this.sink = folderSinkName.sink;
        }

        public FolderSinkName build() {
            return new FolderSinkName(this);
        }
    }
}

